<?php 

/*	Font Sizes
	================================================= */
	$font_body = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_body', 29), 
		get_option(THEMEPREFIX.'_fonts_body_size', 14), 
		get_option(THEMEPREFIX.'_fonts_body_style', 0), 
		get_option(THEMEPREFIX.'_fonts_body_variant', 0)
	);
	$font_blockquote = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_blockquote', 29), 
		get_option(THEMEPREFIX.'_fonts_blockquote_size', 14), 
		get_option(THEMEPREFIX.'_fonts_blockquote_style', 4), 
		get_option(THEMEPREFIX.'_fonts_blockquote_variant', 0)
	);
	
/*	Colors
	================================================= */
	$color_menu 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_menu_bg_top') );
	$color_menu_link 		= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_menu_text') );
	$color_menu_hover 		= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_menu_hover_text') );
	$color_submenu 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_menu_submenu') ); 
	$color_submenu_link 	= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_submenu_text') ); 
	$color_submenu_hover 	= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_submenu_hover_text') );
	$color_footer_text 		= new CurlyThemesColor( get_option(THEMEPREFIX.'_footer_text_color') );
	$color_footer_link 		= new CurlyThemesColor( get_option(THEMEPREFIX.'_footer_link_color') );
	$color_footer_title 	= new CurlyThemesColor( get_option(THEMEPREFIX.'_footer_title_color') );
	$color_primary 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_primary') );
	$color_text 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_text') );
	$color_link 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_links') );
	$color_hover 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_links_hover') );
	$body_bg_color 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_bg_color') );
	$color_h1 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h1') );
	$color_h2 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h2') );
	$color_h3 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h3') );
	$color_h4 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h4') );
	$color_h5 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h5') );
	$color_h6 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h6') );
	
/*	Shortcodes
	================================================= */
	$output = null;

/*	Shortcodes - Accordion
	================================================= */
	$output .= '.panel{
					border-bottom: 1px solid '.$color_text->opacity(0.15).';
				}
				footer .panel{
					border-bottom: 1px solid '.$color_footer_text->opacity(0.15).';
				}';

/*	Shortcodes - Button
	================================================= */
	$output .= '.btn,
				.btn:visited,
				.btn:active,
				.btn:focus,
				input[type="button"],
				input[type="submit"],
				.button{
					background: '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
				}
				.btn:hover,
				input[type="button"]:hover,
				input[type="submit"]:hover,
				.button:hover{
					background: '.$color_primary->darken().';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
				}';							

/*	Shortcodes - Action Boxes
	================================================= */
	$output .= '.action-box{
					background: '.$color_text->opacity(0.075).';
				}
				.action-box.style-1{
					border-color: '.$color_text->opacity(0.25).';
					border-top-color: '.$color_primary.';
				}
				.action-box.style-2{
					border-left-color: '.$color_primary.';
				}
				.action-box.style-3{
					border-color: '.$color_text->opacity(0.25).';
				}
				.action-box.style-4{
					border-color: '.$color_text->opacity(0.25).';
				}
				.action-box.style-5{
					border-color: '.$color_text->opacity(0.25).';
				}';

/*	Shortcodes - Event Agenda
	================================================= */
	$output .= '.event-agenda .row{
					border-bottom: 1px solid '.$color_text->opacity(0.15).';
				}
				.event-agenda .row:hover{
					background: '.$color_text->opacity(0.05).';
				}';					

/*	Shortcodes - Box
	================================================= */
	$output .= '.well{
					border-top: 3px solid '.$color_text->opacity(0.25).';
				}
				.well-1{
					border-top: 3px solid '.$color_primary.'
				}
				.well-2:hover .fa{
					background-color: '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').'
				}
				.well-2:hover h3{
					border-color: '.$color_primary.';
					color: '.$color_primary.'
				}
				.well-3 .fa{
					border-color: '.$color_text.';
					color: '.$color_text.'
				}
				.well-3:hover .fa,
				.well-3:hover h3{
					border-color: '.$color_primary.';
					color: '.$color_primary.'
				}
				.well-4:hover .fa{
					background-color: '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').'
				}
				.well-4:hover h3{
					border-color: '.$color_primary.';
					color: '.$color_primary.'
				}
				.well-5 .fa{
					background-color: '.$color_text.';
					color: '.$color_text->contrast('#000000', '#FFFFFF').'
				}
				.well-5:hover .fa{
					background-color: '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').'
				}
				.well-5:hover h3{
					color: '.$color_primary.'
				}
				.well-5 > div{
					background: '.$color_text->opacity(0.075).';
				}';

/*	Shortcodes - Slider
	================================================= */
	$output .= '.carousel .carousel-control{
					background: '.$color_text->opacity(0.45).';
				}';

/*	Shortcodes - Divider
	================================================= */
	$output .= '.divider.one	{ border-top: 1px solid '.$color_text->opacity(0.25).'; height: 1px; }
				.divider.two	{ border-top: 1px dotted '.$color_text->opacity(0.25).'; height: 1px; }
				.divider.three	{ border-top: 1px dashed '.$color_text->opacity(0.25).'; height: 1px; }
				.divider.four	{ border-top: 3px solid '.$color_text->opacity(0.25) .'; height: 1px; }
				.divider.fire	{ border-top: 1px solid '.$color_text->opacity(0.25) .'; height: 1px; }';

/*	Shortcodes - Tabs
	================================================= */
	$output .= '.tab-content{
					border-bottom: 1px solid '.$color_text->opacity(0.15).';
					border-top: 3px solid '.$color_primary.';
				}
				.nav-tabs .active>a, 
				.nav-tabs .active>a:hover, 
				.nav-tabs .active>a:focus{
					background: '.$color_primary.' !important;
					border-bottom: 1px solid red;
					color: '.$color_primary->contrast('#000000', '#FFFFFF').' !important;
				}
				.nav-tabs li a:hover{
					background: '.$color_text->opacity(0.07).';
				}';				

/*	Shortcodes - Toggle
	================================================= */
	$output .= 'h6[data-toggle="collapse"] i{
					color: '.$color_primary.';
					margin-right: 10px
				}';

/*	Shortcodes - Progress
	================================================= */
	$output .= '.progress{
					height: '.( $font_body->_size * 1.5 + 15).'px;
					line-height: '.($font_body->_size * 1.5 + 15).'px;
					background: '.$color_text->opacity(0.15).';
				}
				.progress .progress-bar{
					font-size: '.$font_body->_size.'px;
				}
				.progress .progress-bar-default{
					background-color: '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
				}';

/*	Shortcodes - Blockquote
	================================================= */
	$output .= 'blockquote{
					border-color: '.$color_primary.';
				}
				.blockquote i:before{
					color: '.$color_link.';
				}
				.blockquote cite{
					color: '.$color_link.';
				}
				.blockquote img{
					border: 5px solid '.$color_text->opacity(0.2).';
				}';

/*	Shortcodes - Testimonials
	================================================= */
	$output .= '.testimonials blockquote{
					background: '.$color_text->opacity(0.07).';
				}
				.testimonials blockquote:before,
				.testimonials cite{ color: '.$color_primary.'; }';

/*	Shortcodes - Lists
	================================================= */
	$output .= '*[class*=\'list-\'] li:before{
					color: '.$color_primary.';
				}';

/*	Shortcodes - Highlighted Paragraph
	================================================= */
	$output .= '.lead,
				.lead p{
					font-size: '.($font_blockquote->_size * 1.5).'px;
					line-height: 1.4em
				}
				.lead.different{
					font-family: '.$font_blockquote->_family.', sans-serif;
				}';

/*	Shortcodes - Person
	================================================= */
	$output .= '.person img{
					border: 5px solid '.$color_text->opacity(0.2).';
				}';	

/*	Shortcodes - Clients Carousel
	================================================= */
	$output .= '.clients-carousel-container .next,
				.clients-carousel-container .prev{
					background-color: '.$color_text->opacity(0.5).';
					color: '.$color_text->contrast('#000000', '#FFFFFF').';
				}
				.clients-carousel-container:hover .next,
				.clients-carousel-container:hover .prev{
					background-color: '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
				}';		

/*	Shortcodes - Pricing Tables
	================================================= */	
	$output .= '.wl-pricing-table .content-column{
					background-color: '.$color_text->opacity(0.05).';
				}
				.wl-pricing-table .content-column h4 *:after, 
				.wl-pricing-table .content-column h4 *:before{ 
					border-top: 3px double '.$color_text->opacity(0.2).';
				}
				
				.wl-pricing-table.light .content-column.highlight-column{
					background-color: '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
				}
				.wl-pricing-table.light .content-column.highlight-column h3,
				.wl-pricing-table.light .content-column.highlight-column h4{
					color: '.$color_text->contrast('#000000', '#FFFFFF').';
				}
				.wl-pricing-table.light .content-column.highlight-column h4 *:after, 
				.wl-pricing-table.light .content-column.highlight-column h4 *:before{ 
					border-top: 3px double '.$color_text->contrast('#000000', '#FFFFFF', 0.2).'
				}';
				

/*	Sliders CSS
	================================================= */	
	if ( is_page() || is_single() ) {
	
		global $post;
		
		// Slider
		$slider 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_slider', null, 'slider', $post->ID );
		$shortcode 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_slider_shortcode', null, 'slider_shortcode', $post->ID);
		$slider 	= $slider->result();
		$shortcode 	= $shortcode->result();
		
		if( $slider == 'ios-slider' ){
		
			// Slider Settings
			$slider_text_color  = new CurlyGetValue( 'meta', THEMEPREFIX . '_slider_text_color', null, 'slider_text_color', $post->ID );
			$slider_color  		= new CurlyGetValue( 'meta', THEMEPREFIX . '_slider_color', null, 'slider_color', $post->ID );
			$slider_text_color 	= new CurlyThemesColor( $slider_text_color );
			$slider_color 		= new CurlyThemesColor( $slider_color );
			
			$output .= '.page-heading{ display:none }';
			
			if( $slider_text_color ) { 
				$output .= '.text1 h3, .text2 h4 { 
							color: '.$slider_text_color.' !important;
							border-left: 5px solid '.$slider_text_color.';
						 }
						 .text1 h3 a, .text2 h4 a{
						 	color: '.$slider_text_color.' !important;
						 }
						 .text1, .text2{
						 	background: '.$slider_color->opacity(0.85).';
						 }
						 html.ie7 .text1, html.ie7 .text2,
						 html.ie8 .text1, html.ie8 .text2{
						 	background: '.$slider_color.';
						 }';
			}			 
			
		} elseif( ($slider == 'layer-slider') && !is_null($shortcode) ){
			$output .= 'header#header{ position:absolute; background: transparent; z-index: 3 }';
			$output .= '#page-heading, .page-heading{ display:none }';
		}
	}

?>