<?php
add_shortcode("icon", "curly_icon"); 		

function curly_icon( $atts, $content = null ) {
	extract(shortcode_atts(array(  
        'icon'  => null,
		'boxed'  => 'no',
		'size'  => null,
		'position' => null
    ), $atts)); 
	
	$css = null;
	
	if ($boxed != "no") $css = 'icon-boxed'; 
	
	switch ($size){
		case '2x'   : $css .= ' icon-2x'; break;
		case '3x'  : $css .= ' icon-3x'; break;
		case '4x'   : $css .= ' icon-4x'; break;
	}
	
	switch ($position){
		case 'left'    : $css .= ' float-left'; break;
		case 'center'  : $css .= ' no-float'; break;
		case 'right'   : $css .= ' float-right'; break;
	}
	
	$inline = null;
	if(isset($atts['color']) || isset($atts['bg']) || isset($atts['border'])){
		$inline  = 'style="';
		$inline .= ($atts['bg'] != null) ? 'background-color: '.$atts['bg'].';' : null;
		$inline .= ($atts['border'] != null) ? 'border: 5px solid '.$atts['border'].';' :  null;
		$inline .= ($atts['color'] != null) ? 'color: '.$atts['color'].';' : null;
		$inline .= '"';
	}
	 
    return '<span class="'.$css.'" '.$inline.'><i class="icon-'.$icon.'"></i></span>';  
}
?>