<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="row">
		<div class="col-lg-2 col-md-2 hidden-sm hidden-xs">
			<time class="post-calendar-date" datetime="<?php echo get_the_time( 'Y-m-d' ) ?>">
				<span><?php echo get_the_time( 'd' ) ?></span>
				<em><?php echo get_the_time( 'M' ) ?></em>
			</time>
			<?php 
			
			if (is_sticky()) { 
				echo '<span class="label label-danger label-format ">'.__('<i class="fa fa-star"></i>', 'CURLYTHEME').'</span>'; 
			} 
			
			if (has_post_format( 'gallery' )) { 
				echo '<span class="label label-danger label-format">'.__('<i class="fa fa-camera"></i>', 'CURLYTHEME').'</span>'; 
			}
			
			if (has_post_format( 'image' )) { 
				echo '<span class="label label-danger label-format">'.__('<i class="fa fa-picture"></i>', 'CURLYTHEME').'</span>'; 
			} 
			
			if (has_post_format( 'video' )) { 
				echo '<span class="label label-danger label-format">'.__('<i class="fa fa-film"></i>', 'CURLYTHEME').'</span>'; 
			} 
			
			if (has_post_format( 'audio' )) { 
				echo '<span class="label label-danger label-format">'.__('<i class="fa fa-music"></i>', 'CURLYTHEME').'</span>'; 
			} 
			
			if (has_post_format( 'quote' )) { 
				echo '<span class="label label-danger label-format">'.__('<i class="fa fa-quote-right"></i>', 'CURLYTHEME').'</span>'; 
			} 
			
			if (has_post_format( 'link' )) { 
				echo '<span class="label label-danger label-format >'.__('<i class="fa fa-link"></i>', 'CURLYTHEME').'</span>'; 
			} 
			
			if (has_post_format( 'chat' )) { 
				echo '<span class="label label-danger label-format">'.__('<i class="fa fa-comments-alt"></i>', 'CURLYTHEME').'</span>'; 
			} 
			
			if (has_post_format( 'status' )) { 
				echo '<span class="label label-danger label-format">'.__('<i class="fa fa-retweet"></i>', 'CURLYTHEME').'</span>'; 
			} 
			
			if (has_post_format( 'aside' )) { 
				echo '<span class="label label-danger label-format">'.__('<i class="fa fa-asterisk"></i>', 'CURLYTHEME').'</span>'; 
			} 
			
			?>
		</div>
		
		<div class="col-lg-10 col-md-10 col-sm-12 col-xs-12">
			<header>
				<h2 class="post-title"><a href="<?php the_permalink() ?>" title="<?php the_title() ?>"><?php the_title() ?></a></h2>
				<?php get_template_part( 'template-parts/featured', 'image' ); ?>
			</header>
			
			<?php get_template_part( 'template-parts/meta' ); ?>
			
			<div class="entry-content">
				<?php the_excerpt() ?>
			</div>
			
			<p>
				<a href="<?php the_permalink(); ?>" title="<?php the_title() ?>" class="continue-reading">
					<?php echo _e('CONTINUE READING', 'CURLYTHEME') ?> <i class="fa fa-caret-right"></i>
				</a>
			</p>
			
			<?php wp_link_pages(); ?>
		</div>
	</div>
</article>