<?php
/**
 * Include and setup custom metaboxes and fields.
 *
 * @category YourThemeOrPlugin
 * @package  Metaboxes
 * @license  http://www.opensource.org/licenses/gpl-license.php GPL v2.0 (or later)
 * @link     https://github.com/jaredatch/Custom-Metaboxes-and-Fields-for-WordPress
 */

add_filter( 'cmb_meta_boxes', 'cmb_sample_metaboxes' );

function cmb_sample_metaboxes( array $meta_boxes ) {

	$prefix = THEMEPREFIX;
	
	$meta_boxes[] = array(
		'id'         => 'contact_page_metabox',
		'title'      => 'Contact Details',
		'pages'      => array( 'page'),
		'show_on'    => array( 'key' => 'page-template', 'value' => array('page-templates/contact.php','page-templates/contact-2.php','page-templates/contact-3.php')),
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, 
		'fields' => array(
		
			array(
				'name' => 'Side Content',
				'id'   => $prefix . 'contact_side',
				'type' => 'wysiwyg',
			),
			array(
				'name' => 'Map Coodinates<br> Latitude',
				'desc' => 'Latitude Coordinates (Please use decimal coordinates)',
				'id'   => $prefix . 'latitude',
				'type' => 'text_medium',
			),
			array(
				'name' => 'Map Coodinates<br> Longitude',
				'desc' => 'Longitude Coordinates (Please use decimal coordinates)',
				'id'   => $prefix . 'longitude',
				'type' => 'text_medium',
			),
			array(
				'name' => 'Map Marker',
				'desc' => 'Use this image to mark your location',
				'id'   => $prefix . 'map_marker',
				'type' => 'file',
			),
			array(
				'name' => 'Map Color',
				'desc' => 'Choose map saturation color. Leave Blank for Default colors.',
				'id'   => $prefix . 'map_color',
				'type' => 'colorpicker',
			),
			
		)
	);
	
	$meta_boxes[] = array(
		'id'         => 'individual_page_metabox',
		'title'      => 'Individual Page Settings',
		'pages'      => array( 'page', 'post' ),
		'context'    => 'normal',
		'priority'   => 'core',
		'show_names' => true, 
		'fields' => array(
			array(
				'name' => 'Page Heading Background Image',
				'desc' => 'Please set a background image for this page only. Recommended size is 1600px * 500px',
				'id'   => $prefix . 'page_settings_heading_image',
				'type' => 'file',
			),
			array(
				'name' => 'Use Large Header',
				'desc' => 'Use this image as a large header (Title & Breadcrumbs will not be visible anymore)',
				'id'   => $prefix . 'large_header',
				'type' => 'checkbox',
			)
		)
	);

	return $meta_boxes;
}

add_action( 'init', 'cmb_initialize_cmb_meta_boxes', 9999 );

?>