<form name="contact-us" id="contact-form">
	<p>
		<input type="text" name='name' placeholder="<?php echo __('Enter your name *', 'CURLYTHEME') ?>" id='name' class='form-control' />
	</p>
	<p>
		<input type="text" name='email' placeholder="<?php echo __('Enter your email address *', 'CURLYTHEME') ?>" id='email' class='form-control' />
	</p>
	<p>
		<textarea name='message' placeholder="<?php echo __('Enter your message *', 'CURLYTHEME') ?>" id='message' rows="3" class='form-control'></textarea>
	</p>
	
	<div class='message'></div>
	<div class="infoWrapper">
		<div class="infoContent">
			<input type='submit' value='Send Message' class="btn" style="margin-top: 10px;" />
		</div>
	</div>
</form>
 
<script type="text/javascript">
		jQuery(function(){
			jQuery("#contact-form").submit(function(){
				jQuery(".message").removeClass("success").removeClass("error").addClass("loader").html("Sending message").fadeIn("slow");
				jQuery.ajax({
					type: "POST",
					url: "<?php echo get_template_directory_uri() .'/plugins/contact-form/ajax.php' ?>",
					data: jQuery(this).serialize(),
					dataType: 'text',
					success: function(msg){
						switch(msg) {
							case "field_error":
								jQuery(".message").removeClass("loader").addClass("error");
								jQuery(".message").html("Please fill in all the required fields.");
								break;
							case "email_error":
								jQuery(".message").removeClass("loader").addClass("error");
								jQuery(".message").html("Please fill a valid email address.");
								break;	
							case "captcha_error":
								jQuery(".message").removeClass("loader").addClass("error");
								jQuery(".message").html("Please type the words correctly and try again!");
								break;
							case "success":
								jQuery(".message").removeClass("loader").addClass("success");
								jQuery(".message").html("Your message has been sent. You'll soon hear from us!");
								jQuery('.infoWrapper').remove();
								break;
							default:
								alert("Something is wrong. Please try again.");
						}
					}
				});
				return false;
			});
		});
</script> 