<?php 

// Template Name: Contact Page 

$curly->header();

$contact->set_side_box_position();

$latitude 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_latitude', null, THEMEPREFIX . 'latitude', $post->ID );
$longitude 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_longitude', null, THEMEPREFIX . 'longitude', $post->ID );
$marker 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_map_marker', null, THEMEPREFIX . 'map_marker', $post->ID );
$color 		= new CurlyGetValue( 'meta', THEMEPREFIX . '_map_color', null, THEMEPREFIX . 'map_color', $post->ID );
$height 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_map_height', null, THEMEPREFIX . 'map_height', $post->ID );
$zoom 		= new CurlyGetValue( 'meta', THEMEPREFIX . '_map_zoom', null, THEMEPREFIX . 'map_zoom', $post->ID );
$map_type 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_map_type', null, THEMEPREFIX . 'map_type', $post->ID );
$side 		= new CurlyGetValue( 'meta', THEMEPREFIX . '_contact_side', null, THEMEPREFIX . 'contact_side', $post->ID );

if($latitude && $longitude) : ?>
<div class="map-holder">
	
	<?php $contact->map( $latitude, $longitude, $height, $map_type, $marker, $zoom, $color ); ?>
	
	<?php if ( $side != null ) : ?>
	<div id="contact-info" class="col-lg-3 col-md-4 visible-md visible-lg">
		<?php $contact->side( $side ); ?>
	</div>
	<div class="visible-sm visible-xs text-center" id="contact-info-below">
		<?php $contact->side( $side );  ?>
	</div>
	<?php endif; ?>
</div>
<?php endif; ?>

<article <?php post_class(); ?>>
	<div class="container page-content">
		<div class="row">
			<?php if ( get_option(THEMEPREFIX.'_general_email') ) : ?>
			<div class="col-lg-8 col-md-8 col-sm-8">
				<?php while ( have_posts() ) : the_post(); ?>
				
				<?php the_content(); ?>
							
				<?php endwhile; ?>
			</div>
			<div class="col-lg-4 col-md-4 col-sm-4">
				<h3 class="special-title"><span><?php _e('Contact Form', 'CURLYTHEME') ?></span></h3>
				<?php $contact->contact_form(); ?>
			</div>
			<?php else : ?>
			<div class="col-lg-12">
				<?php while ( have_posts() ) : the_post(); ?>
				
				<?php the_content() ?>
							
				<?php endwhile; ?>
				
			</div>
			<?php endif; ?>
		</div>
	</div>
</article>

<?php $curly->footer(); ?>