<?php 

// Template Name: Contact Page #3

$curly->header();

$latitude 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_latitude', null, THEMEPREFIX . 'latitude', $post->ID );
$longitude 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_longitude', null, THEMEPREFIX . 'longitude', $post->ID );
$marker 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_map_marker', null, THEMEPREFIX . 'map_marker', $post->ID );
$color 		= new CurlyGetValue( 'meta', THEMEPREFIX . '_map_color', null, THEMEPREFIX . 'map_color', $post->ID );
$height 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_map_height', null, THEMEPREFIX . 'map_height', $post->ID );
$zoom 		= new CurlyGetValue( 'meta', THEMEPREFIX . '_map_zoom', null, THEMEPREFIX . 'map_zoom', $post->ID );
$map_type 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_map_type', null, THEMEPREFIX . 'map_type', $post->ID );
$side 		= new CurlyGetValue( 'meta', THEMEPREFIX . '_contact_side', null, THEMEPREFIX . 'contact_side', $post->ID );

?>
<article <?php post_class(); ?>>
	<div class="container page-content">
		<div class="row">
			<div class="col-lg-8 col-md-8 col-sm-8">
				<?php while ( have_posts() ) : the_post(); ?>
				
				<?php the_content(); ?>
							
				<?php endwhile; ?>
				
				<?php if (get_option(THEMEPREFIX.'_general_email')) : ?>
				<h3 class="special-title"><span><?php _e('Contact Form', 'CURLYTHEME') ?></span></h3>
				<?php $contact->contact_form(); ?>
				<br><br>
				<?php endif; ?>
				
			</div>
			<div class="col-lg-4 col-md-4 col-sm-4">
				<?php if( $latitude && $longitude ) : ?>
				<div class="map-holder featured-image">
					<?php $contact->map( $latitude, $longitude, $height, $map_type, $marker, $zoom, $color ); ?>
				</div>
				
				<?php $contact->side( $side ); ?>
				<?php endif; ?>
			</div>
		</div>
	</div>
</article>

<?php $curly->footer(); ?>