<?php 

	// Template Name: Coming Soon Page 
	
	if( !wp_script_is('curly-vertical-align') ) { 
		wp_enqueue_script('curly-vertical-align');
	}
	
	function curly_coming_soon_position() {
		echo "<script type='text/javascript'>jQuery(document).ready(function() { jQuery('#coming-soon-container').flexVerticalCenter({ cssAttribute: 'padding-top', parentSelector: 'html' });});</script>";
	}
	
	add_action( 'wp_footer', 'curly_coming_soon_position' );
	
?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="apple-mobile-web-app-capable" content="yes">
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<article id="coming-soon-container" <?php post_class(); ?>>
		<div class="container page-content">
			<div class="row">
				<div class="col-lg-6 col-md-6 col-sm-8 col-sm-offset-1 col-md-offset-1 col-lg-offset-3">
					<?php while ( have_posts() ) : the_post(); ?>
					<?php the_content() ?>		
					<?php endwhile; ?>			
				</div>
			</div>
		</div>
	</article>
</body>

<?php wp_footer(); ?>
