/*
 * iosSlider - http://iosscripts.com/iosslider/
 * 
 * Touch Enabled, Responsive jQuery Horizontal Content Slider/Carousel/Image Gallery Plugin
 *
 * A jQuery plugin which allows you to integrate a customizable, cross-browser 
 * content slider into your web presence. Designed for use as a content slider, carousel, 
 * scrolling website banner, or image gallery.
 * 
 * Copyright (c) 2013 Marc Whitbread
 * 
 * Version: v1.2.27 (06/03/2013)
 * Minimum requirements: jQuery v1.4+
 *
 * Advanced requirements:
 * 1) jQuery bind() click event override on slide requires jQuery v1.6+
 *
 * Terms of use:
 *
 * 1) iosSlider is licensed under the Creative Commons – Attribution-NonCommercial 3.0 License.
 * 2) You may use iosSlider free for personal or non-profit purposes, without restriction.
 *	  Attribution is not required but always appreciated. For commercial projects, you
 *	  must purchase a license. You may download and play with the script before deciding to
 *	  fully implement it in your project. Making sure you are satisfied, and knowing iosSlider
 *	  is the right script for your project is paramount.
 * 3) You are not permitted to make the resources found on iosscripts.com available for
 *    distribution elsewhere "as is" without prior consent. If you would like to feature
 *    iosSlider on your site, please do not link directly to the resource zip files. Please
 *    link to the appropriate page on iosscripts.com where users can find the download.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 * GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
 
(function(a){var na=0,W=0,da=0,M=0,Ba="ontouchstart"in window,Ca="onorientationchange"in window,ea=!1,aa=!1,X=!1,oa=!1,ha="pointer",sa="pointer",ia=[],S=[],ta=[],$=[],x=[],ba=[],F=[],j=[],q=[],ua=[],fa=[],e={showScrollbar:function(c,e){c.scrollbarHide&&a("."+e).css({opacity:c.scrollbarOpacity,filter:"alpha(opacity:"+100*c.scrollbarOpacity+")"})},hideScrollbar:function(a,f,b,u,d,g,j,q,z,w){if(a.scrollbar&&a.scrollbarHide)for(var x=b;x<b+25;x++)f[f.length]=e.hideScrollbarIntervalTimer(10*x,u[b],(b+ 24-x)/24,d,g,j,q,z,w,a)},hideScrollbarInterval:function(c,f,b,u,d,g,j,x,z){M=-1*c/q[x]*(d-g-j-u);e.setSliderOffset("."+b,M);a("."+b).css({opacity:z.scrollbarOpacity*f,filter:"alpha(opacity:"+100*z.scrollbarOpacity*f+")"})},slowScrollHorizontalInterval:function(c,f,b,u,d,g,T,N,z,w,K,s,r,t,H,n,k,y,h){if(h.infiniteSlider){if(b<=-1*q[n]){var C=a(c).width();if(b<=-1*ua[n]){var p=-1*K[0];a(f).each(function(b){e.setSliderOffset(a(f)[b],p+k);b<s.length&&(s[b]=-1*p);p+=H[b]});b+=-1*s[0];j[n]=-1*s[0]+k;q[n]= j[n]+C-g;F[n]=0}else{var m=0,I=e.getSliderOffset(a(f[0]),"x");a(f).each(function(b){e.getSliderOffset(this,"x")<I&&(I=e.getSliderOffset(this,"x"),m=b)});r=j[n]+C;e.setSliderOffset(a(f)[m],r);j[n]=-1*s[1]+k;q[n]=j[n]+C-g;s.splice(0,1);s.splice(s.length,0,-1*r+k);F[n]++}}if(b>=-1*j[n]||0<=b){C=a(c).width();if(0<=b){p=-1*K[0];a(f).each(function(b){e.setSliderOffset(a(f)[b],p+k);b<s.length&&(s[b]=-1*p);p+=H[b]});b-=-1*s[0];j[n]=-1*s[0]+k;q[n]=j[n]+C-g;for(F[n]=t;0<-1*s[0]-C+k;){var v=0,A=e.getSliderOffset(a(f[0]), "x");a(f).each(function(b){e.getSliderOffset(this,"x")>A&&(A=e.getSliderOffset(this,"x"),v=b)});r=j[n]-H[v];e.setSliderOffset(a(f)[v],r);s.splice(0,0,-1*r+k);s.splice(s.length-1,1);j[n]=-1*s[0]+k;q[n]=j[n]+C-g;F[n]--;x[n]++}}0>b&&(v=0,A=e.getSliderOffset(a(f[0]),"x"),a(f).each(function(b){e.getSliderOffset(this,"x")>A&&(A=e.getSliderOffset(this,"x"),v=b)}),r=j[n]-H[v],e.setSliderOffset(a(f)[v],r),s.splice(0,0,-1*r+k),s.splice(s.length-1,1),j[n]=-1*s[0]+k,q[n]=j[n]+C-g,F[n]--)}}K=!1;g=e.calcActiveOffset(h, b,s,g,F[n],t,w,n);r=(g+F[n]+t)%t;h.infiniteSlider?r!=ba[n]&&(K=!0):g!=x[n]&&(K=!0);if(K&&(t=new e.args("change",h,c,a(c).children(":eq("+r+")"),r,y),a(c).parent().data("args",t),""!=h.onSlideChange))h.onSlideChange(t);x[n]=g;ba[n]=r;b=Math.floor(b);e.setSliderOffset(c,b);h.scrollbar&&(M=Math.floor((-1*b-j[n]+k)/(q[n]-j[n]+k)*(T-N-d)),c=d-z,b>=-1*j[n]+k?(c=d-z- -1*M,e.setSliderOffset(a("."+u),0)):(b<=-1*q[n]+1&&(c=T-N-z-M),e.setSliderOffset(a("."+u),M)),a("."+u).css({width:c+"px"}))},slowScrollHorizontal:function(c, f,b,u,d,g,T,N,z,w,K,s,r,t,H,n,k,y,h,C,p){var m=e.getSliderOffset(c,"x");g=[];var I=0,v=25/1024*N;frictionCoefficient=p.frictionCoefficient;elasticFrictionCoefficient=p.elasticFrictionCoefficient;snapFrictionCoefficient=p.snapFrictionCoefficient;d>p.snapVelocityThreshold&&p.snapToChildren&&!h?I=1:d<-1*p.snapVelocityThreshold&&(p.snapToChildren&&!h)&&(I=-1);d<-1*v?d=-1*v:d>v&&(d=v);a(c)[0]!==a(y)[0]&&(I*=-1,d*=-2);y=F[H];if(p.infiniteSlider)var A=j[H],l=q[H];h=[];for(var v=[],D=0;D<r.length;D++)h[D]= r[D],D<f.length&&(v[D]=e.getSliderOffset(a(f[D]),"x"));for(;1<d||-1>d;){d*=frictionCoefficient;m+=d;if((m>-1*j[H]||m<-1*q[H])&&!p.infiniteSlider)d*=elasticFrictionCoefficient,m+=d;if(p.infiniteSlider){if(m<=-1*l){for(var l=a(c).width(),M=0,P=v[0],D=0;D<v.length;D++)v[D]<P&&(P=v[D],M=D);D=A+l;v[M]=D;A=-1*h[1]+C;l=A+l-N;h.splice(0,1);h.splice(h.length,0,-1*D+C);y++}if(m>=-1*A){l=a(c).width();M=0;P=v[0];for(D=0;D<v.length;D++)v[D]>P&&(P=v[D],M=D);D=A-t[M];v[M]=D;h.splice(0,0,-1*D+C);h.splice(h.length- 1,1);A=-1*h[0]+C;l=A+l-N;y--}}g[g.length]=m}v=!1;d=e.calcActiveOffset(p,m,h,N,y,k,x[H],H);A=(d+y+k)%k;p.snapToChildren&&(p.infiniteSlider?A!=ba[H]&&(v=!0):d!=x[H]&&(v=!0),0>I&&!v?(d++,d>=r.length&&!p.infinteSlider&&(d=r.length-1)):0<I&&!v&&(d--,0>d&&!p.infinteSlider&&(d=0)));if(p.snapToChildren||(m>-1*j[H]||m<-1*q[H])&&!p.infiniteSlider){(m>-1*j[H]||m<-1*q[H])&&!p.infiniteSlider?g.splice(0,g.length):(g.splice(0.1*g.length,g.length),m=0<g.length?g[g.length-1]:m);for(;m<h[d]-0.5||m>h[d]+0.5;)m=(m-h[d])* snapFrictionCoefficient+h[d],g[g.length]=m;g[g.length]=h[d]}I=1;0!=g.length%2&&(I=0);for(m=0;m<b.length;m++)clearTimeout(b[m]);y=(d+y+k)%k;A=0;for(m=I;m<g.length;m+=2)if(m==I||1<Math.abs(g[m]-A)||m>=g.length-2)A=g[m],b[b.length]=e.slowScrollHorizontalIntervalTimer(10*m,c,f,g[m],u,T,N,z,w,K,d,s,r,n,k,t,H,C,y,p);A=(d+F[H]+k)%k;""!=p.onSlideComplete&&1<g.length&&(b[b.length]=e.onSlideCompleteTimer(10*(m+1),p,c,a(c).children(":eq("+A+")"),y,H));$[H]=b;e.hideScrollbar(p,b,m,g,u,T,N,w,K,H)},onSlideComplete:function(c, f,b,u){b=new e.args("complete",c,a(f),b,u,u);a(f).parent().data("args",b);if(""!=c.onSlideComplete)c.onSlideComplete(b)},getSliderOffset:function(c,e){var b=0;e="x"==e?4:5;if(ea&&!aa&&!X){for(var b=["-webkit-transform","-moz-transform","transform"],u=0;u<b.length;u++)if(void 0!=a(c).css(b[u])&&0<a(c).css(b[u]).length){var d=a(c).css(b[u]).split(",");break}b=parseInt(d[e],10)}else b=parseInt(a(c).css("left"),10);return b},setSliderOffset:function(c,e){ea&&!aa&&!X?a(c).css({webkitTransform:"matrix(1,0,0,1,"+ e+",0)",MozTransform:"matrix(1,0,0,1,"+e+",0)",transform:"matrix(1,0,0,1,"+e+",0)"}):a(c).css({left:e+"px"})},setBrowserInfo:function(){null!=navigator.userAgent.match("WebKit")?(ha="-webkit-grab",sa="-webkit-grabbing"):null!=navigator.userAgent.match("Gecko")?(ha="move",sa="-moz-grabbing"):null!=navigator.userAgent.match("MSIE 7")?oa=aa=!0:null!=navigator.userAgent.match("MSIE 8")?oa=X=!0:null!=navigator.userAgent.match("MSIE 9")&&(oa=!0)},has3DTransform:function(){var c=!1,e=a("<div />").css({webkitTransform:"matrix(1,1,1,1,1,1)", MozTransform:"matrix(1,1,1,1,1,1)",transform:"matrix(1,1,1,1,1,1)"});""==e.attr("style")?c=!1:void 0!=e.attr("style")&&(c=!0);return c},getSlideNumber:function(a,e,b){return(a-F[e]+b)%b},calcActiveOffset:function(a,e,b,u,d,g){d=!1;a=[];var j;e>b[0]&&(j=0);e<b[b.length-1]&&(j=g-1);for(g=0;g<b.length;g++)b[g]<=e&&b[g]>e-u&&(!d&&b[g]!=e&&(a[a.length]=b[g-1]),a[a.length]=b[g],d=!0);0==a.length&&(a[0]=b[b.length-1]);for(g=d=0;g<a.length;g++){var q=Math.abs(e-a[g]);q<u&&(d=a[g],u=q)}for(g=0;g<b.length;g++)d== b[g]&&(j=g);return j},changeSlide:function(c,f,b,u,d,g,j,q,z,w,K,s,r,t,H,n,k,y){e.autoSlidePause(t);for(var h=0;h<u.length;h++)clearTimeout(u[h]);var C=Math.ceil(y.autoSlideTransTimer/10)+1,p=e.getSliderOffset(f,"x"),m=s[c],m=m-p,I=c-(x[t]+F[t]+n)%n;if(y.infiniteSlider){c=(c-F[t]+2*n)%n;h=!1;0==c&&2==n&&(c=n,s[c]=s[c-1]-a(b).eq(0).outerWidth(!0),h=!0);var m=s[c],m=m-p,v=[s[c]-a(f).width(),s[c]+a(f).width()];h&&s.splice(s.length-1,1);for(h=0;h<v.length;h++)Math.abs(v[h]-p)<Math.abs(m)&&(m=v[h]-p); 0>m&&-1==I?m+=a(f).width():0<m&&1==I&&(m-=a(f).width())}I=[];e.showScrollbar(y,d);for(h=0;h<=C;h++)v=h,v/=C,v--,v=p+m*(Math.pow(v,5)+1),I[I.length]=v;C=(c+F[t]+n)%n;for(h=p=0;h<I.length;h++){if(0==h||1<Math.abs(I[h]-p)||h>=I.length-2)p=I[h],u[h]=e.slowScrollHorizontalIntervalTimer(10*(h+1),f,b,I[h],d,g,j,q,z,w,c,K,s,H,n,r,t,k,C,y);0==h&&""!=y.onSlideStart&&(C=(x[t]+F[t]+n)%n,y.onSlideStart(new e.args("start",y,f,a(f).children(":eq("+C+")"),C,c)))}p=!1;y.infiniteSlider?C!=ba[t]&&(p=!0):c!=x[t]&&(p= !0);p&&""!=y.onSlideComplete&&(u[u.length]=e.onSlideCompleteTimer(10*(h+1),y,f,a(f).children(":eq("+C+")"),C,t));$[t]=u;e.hideScrollbar(y,u,h,I,d,g,j,z,w,t);e.autoSlide(f,b,u,d,g,j,q,z,w,K,s,r,t,H,n,k,y)},autoSlide:function(a,f,b,u,d,g,j,q,z,w,K,s,r,t,H,n,k){if(!S[r].autoSlide)return!1;e.autoSlidePause(r);ia[r]=setTimeout(function(){!k.infiniteSlider&&x[r]>K.length-1&&(x[r]-=H);e.changeSlide((x[r]+F[r]+K.length+1)%K.length,a,f,b,u,d,g,j,q,z,w,K,s,r,t,H,n,k);e.autoSlide(a,f,b,u,d,g,j,q,z,w,K,s,r,t, H,n,k)},k.autoSlideTimer+k.autoSlideTransTimer)},autoSlidePause:function(a){clearTimeout(ia[a])},isUnselectable:function(c,e){return""!=e.unselectableSelector&&1==a(c).closest(e.unselectableSelector).size()?!0:!1},slowScrollHorizontalIntervalTimer:function(a,f,b,u,d,g,j,q,x,w,F,s,r,t,H,n,k,y,h,C){return setTimeout(function(){e.slowScrollHorizontalInterval(f,b,u,d,g,j,q,x,w,F,s,r,t,H,n,k,y,h,C)},a)},onSlideCompleteTimer:function(a,f,b,u,d,g){return setTimeout(function(){e.onSlideComplete(f,b,u,d,g)}, a)},hideScrollbarIntervalTimer:function(a,f,b,u,d,g,j,q,x,w){return setTimeout(function(){e.hideScrollbarInterval(f,b,u,d,g,j,q,x,w)},a)},args:function(c,f,b,j,d,g){this.prevSlideNumber=void 0==a(b).parent().data("args")?void 0:a(b).parent().data("args").prevSlideNumber;this.prevSlideObject=void 0==a(b).parent().data("args")?void 0:a(b).parent().data("args").prevSlideObject;this.targetSlideNumber=g+1;this.targetSlideObject=a(b).children(":eq("+this.targetSlideOffset+")");this.slideChanged=!1;"load"== c?this.targetSlideObject=this.targetSlideNumber=void 0:"start"==c?this.targetSlideObject=this.targetSlideNumber=void 0:"change"==c?(this.slideChanged=!0,this.prevSlideNumber=void 0==a(b).parent().data("args")?f.startAtSlide:a(b).parent().data("args").currentSlideNumber,this.prevSlideObject=a(b).children(":eq("+this.prevSlideNumber+")")):"complete"==c&&(this.slideChanged=a(b).parent().data("args").slideChanged);this.settings=f;this.data=a(b).parent().data("iosslider");this.sliderObject=b;this.sliderContainerObject= a(b).parent();this.currentSlideObject=j;this.currentSlideNumber=d+1;this.currentSliderOffset=-1*e.getSliderOffset(b,"x")},preventDrag:function(a){a.preventDefault()},preventClick:function(a){a.stopImmediatePropagation();return!1},enableClick:function(){return!0}};e.setBrowserInfo();var V={init:function(c,f){ea=e.has3DTransform();var b=a.extend(!0,{elasticPullResistance:0.6,frictionCoefficient:0.92,elasticFrictionCoefficient:0.6,snapFrictionCoefficient:0.92,snapToChildren:!1,snapSlideCenter:!1,startAtSlide:1, scrollbar:!1,scrollbarDrag:!1,scrollbarHide:!0,scrollbarLocation:"top",scrollbarContainer:"",scrollbarOpacity:0.4,scrollbarHeight:"4px",scrollbarBorder:"0",scrollbarMargin:"5px",scrollbarBackground:"#000",scrollbarBorderRadius:"100px",scrollbarShadow:"0 0 0 #000",scrollbarElasticPullResistance:0.9,desktopClickDrag:!1,keyboardControls:!1,tabToAdvance:!1,responsiveSlideContainer:!0,responsiveSlides:!0,navSlideSelector:"",navPrevSelector:"",navNextSelector:"",autoSlideToggleSelector:"",autoSlide:!1, autoSlideTimer:5E3,autoSlideTransTimer:750,autoSlideHoverPause:!0,infiniteSlider:!1,snapVelocityThreshold:5,slideStartVelocityThreshold:0,horizontalSlideLockThreshold:5,verticalSlideLockThreshold:3,stageCSS:{position:"relative",top:"0",left:"0",overflow:"hidden",zIndex:1},unselectableSelector:"",onSliderLoaded:"",onSliderUpdate:"",onSliderResize:"",onSlideStart:"",onSlideChange:"",onSlideComplete:""},c);void 0==f&&(f=this);return a(f).each(function(){function c(){e.autoSlidePause(d);va=a(E).find("a"); za=a(E).find("[onclick]");pa=a(E).find("*");a(y).css("width","");a(y).css("height","");a(E).css("width","");B=a(E).children().not("script").get();ga=[];L=[];a(B).css("width","");q[d]=0;l=[];H=a(y).parent().width();h=a(y).outerWidth(!0);b.responsiveSlideContainer&&(h=a(y).outerWidth(!0)>H?H:a(y).outerWidth(!0));a(y).css({position:b.stageCSS.position,top:b.stageCSS.top,left:b.stageCSS.left,overflow:b.stageCSS.overflow,zIndex:b.stageCSS.zIndex,webkitPerspective:1E3,webkitBackfaceVisibility:"hidden", msTouchAction:"pan-y",width:h});a(b.unselectableSelector).css({cursor:"default"});for(var G=0;G<B.length;G++){ga[G]=a(B[G]).width();L[G]=a(B[G]).outerWidth(!0);var u=L[G];b.responsiveSlides&&(L[G]>h?(u=h+-1*(L[G]-ga[G]),ga[G]=u,L[G]=h):u=ga[G],a(B[G]).css({width:u}));a(B[G]).css({webkitBackfaceVisibility:"hidden",position:"absolute",top:0});l[G]=-1*q[d];q[d]=q[d]+u+(L[G]-ga[G])}b.snapSlideCenter&&(k=0.5*(h-L[0]),b.responsiveSlides&&L[0]>h&&(k=0));ua[d]=2*q[d];for(G=0;G<B.length;G++)e.setSliderOffset(a(B[G]), -1*l[G]+q[d]+k),l[G]-=q[d];if(!b.infiniteSlider&&!b.snapSlideCenter){for(G=0;G<l.length&&!(l[G]<=-1*(2*q[d]-h));G++)ia=G;l.splice(ia+1,l.length);l[l.length]=-1*(2*q[d]-h)}for(G=0;G<l.length;G++)D[G]=l[G];v&&(b.startAtSlide=S[d].startAtSlide>l.length?l.length:S[d].startAtSlide,b.infiniteSlider?(b.startAtSlide=(S[d].startAtSlide-1+J)%J,x[d]=S[d].startAtSlide):(b.startAtSlide=0>S[d].startAtSlide-1?l.length-1:S[d].startAtSlide,x[d]=S[d].startAtSlide-1),ba[d]=x[d]);j[d]=q[d]+k;a(E).css({position:"relative", cursor:ha,webkitPerspective:"0",webkitBackfaceVisibility:"hidden",width:q[d]+"px"});Q=q[d];q[d]=2*q[d]-h+2*k;(Y=Q<h?!0:!1)&&a(E).css({cursor:"default"});n=a(y).parent().outerHeight(!0);C=a(y).height();b.responsiveSlideContainer&&(C=C>n?n:C);a(y).css({height:C});e.setSliderOffset(E,l[x[d]]);if(b.infiniteSlider&&!Y){G=e.getSliderOffset(a(E),"x");for(u=-1*((F[d]+J)%J);0>u;){var A=0,ja=e.getSliderOffset(a(B[0]),"x");a(B).each(function(a){e.getSliderOffset(this,"x")<ja&&(ja=e.getSliderOffset(this,"x"), A=a)});var I=j[d]+Q;e.setSliderOffset(a(B)[A],I);j[d]=-1*l[1]+k;q[d]=j[d]+Q-h;l.splice(0,1);l.splice(l.length,0,-1*I+k);u++}for(;0<-1*l[0]-Q+k&&b.snapSlideCenter&&v;){var M=0,N=e.getSliderOffset(a(B[0]),"x");a(B).each(function(a){e.getSliderOffset(this,"x")>N&&(N=e.getSliderOffset(this,"x"),M=a)});I=j[d]-L[M];e.setSliderOffset(a(B)[M],I);l.splice(0,0,-1*I+k);l.splice(l.length-1,1);j[d]=-1*l[0]+k;q[d]=j[d]+Q-h;F[d]--;x[d]++}for(;G<=-1*q[d];)A=0,ja=e.getSliderOffset(a(B[0]),"x"),a(B).each(function(a){e.getSliderOffset(this, "x")<ja&&(ja=e.getSliderOffset(this,"x"),A=a)}),I=j[d]+Q,e.setSliderOffset(a(B)[A],I),j[d]=-1*l[1]+k,q[d]=j[d]+Q-h,l.splice(0,1),l.splice(l.length,0,-1*I+k),F[d]++,x[d]--}e.setSliderOffset(E,l[x[d]]);b.desktopClickDrag||a(E).css({cursor:"default"});b.scrollbar&&(a("."+z).css({margin:b.scrollbarMargin,overflow:"hidden",display:"none"}),a("."+z+" ."+w).css({border:b.scrollbarBorder}),p=parseInt(a("."+z).css("marginLeft"))+parseInt(a("."+z).css("marginRight")),m=parseInt(a("."+z+" ."+w).css("borderLeftWidth"), 10)+parseInt(a("."+z+" ."+w).css("borderRightWidth"),10),r=""!=b.scrollbarContainer?a(b.scrollbarContainer).width():h,t=h/Q*(r-p),b.scrollbarHide||(V=b.scrollbarOpacity),a("."+z).css({position:"absolute",left:0,width:r-p+"px",margin:b.scrollbarMargin}),"top"==b.scrollbarLocation?a("."+z).css("top","0"):a("."+z).css("bottom","0"),a("."+z+" ."+w).css({borderRadius:b.scrollbarBorderRadius,background:b.scrollbarBackground,height:b.scrollbarHeight,width:t-m+"px",minWidth:b.scrollbarHeight,border:b.scrollbarBorder, webkitPerspective:1E3,webkitBackfaceVisibility:"hidden",position:"relative",opacity:V,filter:"alpha(opacity:"+100*V+")",boxShadow:b.scrollbarShadow}),e.setSliderOffset(a("."+z+" ."+w),Math.floor((-1*l[x[d]]-j[d]+k)/(q[d]-j[d]+k)*(r-p-t))),a("."+z).css({display:"block"}),K=a("."+z+" ."+w),s=a("."+z));b.scrollbarDrag&&!Y&&a("."+z+" ."+w).css({cursor:ha});b.infiniteSlider&&(R=(q[d]+h)/3);""!=b.navSlideSelector&&a(b.navSlideSelector).each(function(c){a(this).css({cursor:"pointer"});a(this).unbind(O).bind(O, function(G){"touchstart"==G.type?a(this).unbind("click.iosSliderEvent"):a(this).unbind("touchstart.iosSliderEvent");O=G.type+".iosSliderEvent";e.changeSlide(c,E,B,f,w,t,h,r,p,m,D,l,L,d,R,J,k,b)})});""!=b.navPrevSelector&&(a(b.navPrevSelector).css({cursor:"pointer"}),a(b.navPrevSelector).unbind(O).bind(O,function(c){"touchstart"==c.type?a(this).unbind("click.iosSliderEvent"):a(this).unbind("touchstart.iosSliderEvent");O=c.type+".iosSliderEvent";c=(x[d]+F[d]+J)%J;(0<c||b.infiniteSlider)&&e.changeSlide(c- 1,E,B,f,w,t,h,r,p,m,D,l,L,d,R,J,k,b)}));""!=b.navNextSelector&&(a(b.navNextSelector).css({cursor:"pointer"}),a(b.navNextSelector).unbind(O).bind(O,function(c){"touchstart"==c.type?a(this).unbind("click.iosSliderEvent"):a(this).unbind("touchstart.iosSliderEvent");O=c.type+".iosSliderEvent";c=(x[d]+F[d]+J)%J;(c<l.length-1||b.infiniteSlider)&&e.changeSlide(c+1,E,B,f,w,t,h,r,p,m,D,l,L,d,R,J,k,b)}));b.autoSlide&&!Y&&""!=b.autoSlideToggleSelector&&(a(b.autoSlideToggleSelector).css({cursor:"pointer"}),a(b.autoSlideToggleSelector).unbind(O).bind(O, function(c){"touchstart"==c.type?a(this).unbind("click.iosSliderEvent"):a(this).unbind("touchstart.iosSliderEvent");O=c.type+".iosSliderEvent";wa?(e.autoSlide(E,B,f,w,t,h,r,p,m,D,l,L,d,R,J,k,b),wa=!1,a(b.autoSlideToggleSelector).removeClass("on")):(e.autoSlidePause(d),wa=!0,a(b.autoSlideToggleSelector).addClass("on"))}));e.autoSlide(E,B,f,w,t,h,r,p,m,D,l,L,d,R,J,k,b);a(y).bind("mouseleave.iosSliderEvent",function(){e.autoSlide(E,B,f,w,t,h,r,p,m,D,l,L,d,R,J,k,b)});a(y).bind("touchend.iosSliderEvent", function(){e.autoSlide(E,B,f,w,t,h,r,p,m,D,l,L,d,R,J,k,b)});b.autoSlidePauseHover&&a(y).bind("mouseenter.iosSliderEvent",function(){e.autoSlidePause(d)});a(y).data("iosslider",{obj:Aa,settings:b,scrollerNode:E,slideNodes:B,numberOfSlides:J,centeredSlideOffset:k,sliderNumber:d,originalOffsets:D,childrenOffsets:l,sliderMax:q[d],scrollbarClass:w,scrollbarWidth:t,scrollbarStageWidth:r,stageWidth:h,scrollMargin:p,scrollBorder:m,infiniteSliderOffset:F[d],infiniteSliderWidth:R,slideNodeOuterWidths:L});v= !1;return!0}na++;var d=na,f=[];S[d]=b;j[d]=0;q[d]=0;var T=[0,0],N=[0,0],z="scrollbarBlock"+na,w="scrollbar"+na,K,s,r,t,H,n,k=0,y=a(this),h,C,p,m,I,v=!0,A=-1,l,D=[],V=0,P=0,ea=0,E=a(this).children(":first-child"),B,ga,L,J=a(E).children().not("script").size(),U=!1,ia=0,xa=!1,qa=void 0,R;F[d]=0;var Y=!1,wa=!1;ta[d]=!1;var Z,ra=!1,ka=!1,O="touchstart.iosSliderEvent click.iosSliderEvent",Q,va,za,pa;fa[d]=!1;$[d]=[];b.scrollbarDrag&&(b.scrollbar=!0,b.scrollbarHide=!1);var Aa=a(this);if(void 0!=Aa.data("iosslider"))return!0; a(this).find("img").bind("dragstart.iosSliderEvent",function(a){a.preventDefault()});b.infiniteSlider&&(b.scrollbar=!1);b.infiniteSlider&&1==J&&(b.infiniteSlider=!1);b.scrollbar&&(""!=b.scrollbarContainer?a(b.scrollbarContainer).append("<div class = '"+z+"'><div class = '"+w+"'></div></div>"):a(E).parent().append("<div class = '"+z+"'><div class = '"+w+"'></div></div>"));if(!c())return!0;a(this).find("a").bind("mousedown",e.preventDrag);a(this).find("[onclick]").bind("click",e.preventDrag).each(function(){a(this).data("onclick", this.onclick)});A=e.calcActiveOffset(b,e.getSliderOffset(a(E),"x"),l,h,F[d],J,void 0,d);A=(A+F[d]+J)%J;A=new e.args("load",b,E,a(E).children(":eq("+A+")"),A,A);a(y).data("args",A);if(""!=b.onSliderLoaded)b.onSliderLoaded(A);if(S[d].responsiveSlides||S[d].responsiveSlideContainer)A=Ca?"orientationchange":"resize",a(window).bind(A+".iosSliderEvent-"+d,function(){if(!c())return!0;var d=a(y).data("args");if(""!=b.onSliderResize)b.onSliderResize(d)});(b.keyboardControls||b.tabToAdvance)&&!Y&&a(document).bind("keydown.iosSliderEvent", function(a){!aa&&!X&&(a=a.originalEvent);if(37==a.keyCode&&b.keyboardControls)a.preventDefault(),a=(x[d]+F[d]+J)%J,(0<a||b.infiniteSlider)&&e.changeSlide(a-1,E,B,f,w,t,h,r,p,m,D,l,L,d,R,J,k,b);else if(39==a.keyCode&&b.keyboardControls||9==a.keyCode&&b.tabToAdvance)a.preventDefault(),a=(x[d]+F[d]+J)%J,(a<l.length-1||b.infiniteSlider)&&e.changeSlide(a+1,E,B,f,w,t,h,r,p,m,D,l,L,d,R,J,k,b)});if(Ba||b.desktopClickDrag){var ca=!1,la=a(E),ma=a(E),ya=!1;b.scrollbarDrag&&(la=la.add(K),ma=ma.add(s));a(la).bind("mousedown.iosSliderEvent touchstart.iosSliderEvent", function(c){if(ca)return!0;ca=!0;"touchstart"==c.type?a(ma).unbind("mousedown.iosSliderEvent"):a(ma).unbind("touchstart.iosSliderEvent");if(fa[d]||Y||(ya=e.isUnselectable(c.target,b)))return U=ca=!1,!0;Z=a(this)[0]===a(K)[0]?K:E;!aa&&!X&&(c=c.originalEvent);e.autoSlidePause(d);pa.unbind(".disableClick");if("touchstart"==c.type)eventX=c.touches[0].pageX,eventY=c.touches[0].pageY;else{if(window.getSelection)window.getSelection().empty?window.getSelection().empty():window.getSelection().removeAllRanges&& window.getSelection().removeAllRanges();else if(document.selection)if(X)try{document.selection.empty()}catch(h){}else document.selection.empty();eventX=c.pageX;eventY=c.pageY;xa=!0;qa=E;a(this).css({cursor:sa})}T=[0,0];N=[0,0];W=0;U=!1;for(c=0;c<f.length;c++)clearTimeout(f[c]);c=e.getSliderOffset(E,"x");c>-1*j[d]+k+Q?(c=-1*j[d]+k+Q,e.setSliderOffset(a("."+w),c),a("."+w).css({width:t-m+"px"})):c<-1*q[d]&&(e.setSliderOffset(a("."+w),r-p-t),a("."+w).css({width:t-m+"px"}));c=a(this)[0]===a(K)[0]?j[d]: 0;P=-1*(e.getSliderOffset(this,"x")-eventX-c);e.getSliderOffset(this,"y");T[1]=eventX;N[1]=eventY;ka=!1});a(ma).bind("touchmove.iosSliderEvent mousemove.iosSliderEvent",function(c){!aa&&!X&&(c=c.originalEvent);if(fa[d]||Y||ya)return!0;var f=0;if("touchmove"==c.type)eventX=c.touches[0].pageX,eventY=c.touches[0].pageY;else{if(window.getSelection)window.getSelection().empty||window.getSelection().removeAllRanges&&window.getSelection().removeAllRanges();else if(document.selection)if(X)try{document.selection.empty()}catch(u){}else document.selection.empty(); eventX=c.pageX;eventY=c.pageY;if(!xa||!oa&&("undefined"!=typeof c.webkitMovementX||"undefined"!=typeof c.webkitMovementY)&&0===c.webkitMovementY&&0===c.webkitMovementX)return!0}T[0]=T[1];T[1]=eventX;W=(T[1]-T[0])/2;N[0]=N[1];N[1]=eventY;da=(N[1]-N[0])/2;if(!U){var g=(x[d]+F[d]+J)%J,g=new e.args("start",b,E,a(E).children(":eq("+g+")"),g,void 0);a(y).data("args",g);if(""!=b.onSlideStart)b.onSlideStart(g)}if((da>b.verticalSlideLockThreshold||da<-1*b.verticalSlideLockThreshold)&&"touchmove"==c.type&& !U)ra=!0;(W>b.horizontalSlideLockThreshold||W<-1*b.horizontalSlideLockThreshold)&&"touchmove"==c.type&&c.preventDefault();if(W>b.slideStartVelocityThreshold||W<-1*b.slideStartVelocityThreshold)U=!0;if(U&&!ra){var g=e.getSliderOffset(E,"x"),n=a(Z)[0]===a(K)[0]?j[d]:k,v=a(Z)[0]===a(K)[0]?(j[d]-q[d]-k)/(scrollbarStageHeight-p-scrollbarHeight):1,s=a(Z)[0]===a(K)[0]?b.scrollbarElasticPullResistance:b.elasticPullResistance,A=b.snapSlideCenter&&a(Z)[0]===a(K)[0]?0:k,H=b.snapSlideCenter&&a(Z)[0]===a(K)[0]? k:0;"touchmove"==c.type&&(ea!=c.touches.length&&(P=-1*g+eventX),ea=c.touches.length);if(b.infiniteSlider){if(g<=-1*q[d]){var z=a(E).width();if(g<=-1*ua[d]){var C=-1*D[0];a(B).each(function(b){e.setSliderOffset(a(B)[b],C+k);b<l.length&&(l[b]=-1*C);C+=L[b]});P-=-1*l[0];j[d]=-1*l[0]+k;q[d]=j[d]+z-h;F[d]=0}else{var R=0,S=e.getSliderOffset(a(B[0]),"x");a(B).each(function(a){e.getSliderOffset(this,"x")<S&&(S=e.getSliderOffset(this,"x"),R=a)});s=j[d]+z;e.setSliderOffset(a(B)[R],s);j[d]=-1*l[1]+k;q[d]=j[d]+ z-h;l.splice(0,1);l.splice(l.length,0,-1*s+k);F[d]++}}if(g>=-1*j[d]||0<=g)if(z=a(E).width(),0<=g){C=-1*D[0];a(B).each(function(b){e.setSliderOffset(a(B)[b],C+k);b<l.length&&(l[b]=-1*C);C+=L[b]});P+=-1*l[0];j[d]=-1*l[0]+k;q[d]=j[d]+z-h;for(F[d]=J;0<-1*l[0]-z+k;){var O=0,Q=e.getSliderOffset(a(B[0]),"x");a(B).each(function(a){e.getSliderOffset(this,"x")>Q&&(Q=e.getSliderOffset(this,"x"),O=a)});s=j[d]-L[O];e.setSliderOffset(a(B)[O],s);l.splice(0,0,-1*s+k);l.splice(l.length-1,1);j[d]=-1*l[0]+k;q[d]=j[d]+ z-h;F[d]--;x[d]++}}else O=0,Q=e.getSliderOffset(a(B[0]),"x"),a(B).each(function(a){e.getSliderOffset(this,"x")>Q&&(Q=e.getSliderOffset(this,"x"),O=a)}),s=j[d]-L[O],e.setSliderOffset(a(B)[O],s),l.splice(0,0,-1*s+k),l.splice(l.length-1,1),j[d]=-1*l[0]+k,q[d]=j[d]+z-h,F[d]--}else z=a(E).width(),g>-1*j[d]+k&&(f=-1*(j[d]+-1*(P-n-eventX+A)*v-n)*s/v),g<-1*q[d]&&(f=-1*(q[d]+H+-1*(P-n-eventX)*v-n)*s/v);e.setSliderOffset(E,-1*(P-n-eventX-f)*v-n+H);b.scrollbar&&(e.showScrollbar(b,w),M=Math.floor((P-eventX-f- j[d]+A)/(q[d]-j[d]+k)*(r-p-t)*v),g=t,0>=M?(g=t-m- -1*M,e.setSliderOffset(a("."+w),0),a("."+w).css({width:g+"px"})):M>=r-p-m-t?(g=r-p-m-M,e.setSliderOffset(a("."+w),M),a("."+w).css({width:g+"px"})):e.setSliderOffset(a("."+w),M));"touchmove"==c.type&&(I=c.touches[0].pageX);c=!1;f=e.calcActiveOffset(b,-1*(P-eventX-f),l,h,F[d],J,void 0,d);g=(f+F[d]+J)%J;b.infiniteSlider?g!=ba[d]&&(c=!0):f!=x[d]&&(c=!0);if(c&&(x[d]=f,ba[d]=g,ka=!0,g=new e.args("change",b,E,a(E).children(":eq("+g+")"),g,g),a(y).data("args", g),""!=b.onSlideChange))b.onSlideChange(g)}ca=!1});A=a(window);if(X||aa)A=a(document);a(la).bind("touchend.iosSliderEvent",function(a){a=a.originalEvent;if(fa[d]||Y||ya)return!0;if(0!=a.touches.length)for(var c=0;c<a.touches.length;c++)a.touches[c].pageX==I&&e.slowScrollHorizontal(E,B,f,w,W,da,t,h,r,p,m,D,l,L,d,R,J,Z,ka,k,b);else e.slowScrollHorizontal(E,B,f,w,W,da,t,h,r,p,m,D,l,L,d,R,J,Z,ka,k,b);ca=ra=!1});a(A).bind("mouseup.iosSliderEvent-"+d,function(){U?va.unbind("click.disableClick").bind("click.disableClick", e.preventClick):va.unbind("click.disableClick").bind("click.disableClick",e.enableClick);za.each(function(){this.onclick=function(b){if(U)return!1;a(this).data("onclick").call(this,b||window.event)}});1.8<=parseFloat(a().jquery)?pa.each(function(){var b=a._data(this,"events");if(void 0!=b&&void 0!=b.click&&"iosSliderEvent"!=b.click[0].namespace){if(!U)return!1;a(this).one("click.disableClick",e.preventClick);var b=a._data(this,"events").click,c=b.pop();b.splice(0,0,c)}}):1.6<=parseFloat(a().jquery)&& pa.each(function(){var b=a(this).data("events");if(void 0!=b&&void 0!=b.click&&"iosSliderEvent"!=b.click[0].namespace){if(!U)return!1;a(this).one("click.disableClick",e.preventClick);var b=a(this).data("events").click,c=b.pop();b.splice(0,0,c)}});if(!ta[d]){if(Y)return!0;a(la).css({cursor:ha});xa=!1;if(void 0==qa)return!0;e.slowScrollHorizontal(qa,B,f,w,W,da,t,h,r,p,m,D,l,L,d,R,J,Z,ka,k,b);qa=void 0}ca=ra=!1})}})},destroy:function(c,f){void 0==f&&(f=this);return a(f).each(function(){var b=a(this), f=b.data("iosslider");if(void 0==f)return!1;void 0==c&&(c=!0);e.autoSlidePause(f.sliderNumber);ta[f.sliderNumber]=!0;a(window).unbind(".iosSliderEvent-"+f.sliderNumber);a(document).unbind(".iosSliderEvent-"+f.sliderNumber);a(document).unbind("keydown.iosSliderEvent");a(this).unbind(".iosSliderEvent");a(this).children(":first-child").unbind(".iosSliderEvent");a(this).children(":first-child").children().unbind(".iosSliderEvent");c&&(a(this).attr("style",""),a(this).children(":first-child").attr("style", ""),a(this).children(":first-child").children().attr("style",""),a(f.settings.navSlideSelector).attr("style",""),a(f.settings.navPrevSelector).attr("style",""),a(f.settings.navNextSelector).attr("style",""),a(f.settings.autoSlideToggleSelector).attr("style",""),a(f.settings.unselectableSelector).attr("style",""));f.settings.scrollbar&&a(".scrollbarBlock"+f.sliderNumber).remove();for(var f=$[f.sliderNumber],d=0;d<f.length;d++)clearTimeout(f[d]);b.removeData("iosslider");b.removeData("args")})},update:function(c){void 0== c&&(c=this);return a(c).each(function(){var c=a(this),b=c.data("iosslider");if(void 0==b)return!1;b.settings.startAtSlide=c.data("args").currentSlideNumber;V.destroy(!1,this);1!=b.numberOfSlides&&b.settings.infiniteSlider&&(b.settings.startAtSlide=(x[b.sliderNumber]+1+F[b.sliderNumber]+b.numberOfSlides)%b.numberOfSlides);V.init(b.settings,this);c=new e.args("update",b.settings,b.scrollerNode,a(b.scrollerNode).children(":eq("+(b.settings.startAtSlide-1)+")"),b.settings.startAtSlide-1,b.settings.startAtSlide- 1);a(b.stageNode).data("args",c);if(""!=b.settings.onSliderUpdate)b.settings.onSliderUpdate(c)})},addSlide:function(c,e){return this.each(function(){var b=a(this),j=b.data("iosslider");if(void 0==j)return!1;0==a(j.scrollerNode).children().size()?(a(j.scrollerNode).append(c),b.data("args").currentSlideNumber=1):j.settings.infiniteSlider?(1==e?a(j.scrollerNode).children(":eq(0)").before(c):a(j.scrollerNode).children(":eq("+(e-2)+")").after(c),-1>F[j.sliderNumber]&&x[j.sliderNumber]--,b.data("args").currentSlideNumber>= e&&x[j.sliderNumber]++):(e<=j.numberOfSlides?a(j.scrollerNode).children(":eq("+(e-1)+")").before(c):a(j.scrollerNode).children(":eq("+(e-2)+")").after(c),b.data("args").currentSlideNumber>=e&&b.data("args").currentSlideNumber++);b.data("iosslider").numberOfSlides++;V.update(this)})},removeSlide:function(c){return this.each(function(){var e=a(this).data("iosslider");if(void 0==e)return!1;a(e.scrollerNode).children(":eq("+(c-1)+")").remove();x[e.sliderNumber]>c-1&&x[e.sliderNumber]--;V.update(this)})}, goToSlide:function(c,f){void 0==f&&(f=this);return a(f).each(function(){var b=a(this).data("iosslider");if(void 0==b)return!1;c=c>b.childrenOffsets.length?b.childrenOffsets.length-1:c-1;e.changeSlide(c,a(b.scrollerNode),a(b.slideNodes),$[b.sliderNumber],b.scrollbarClass,b.scrollbarWidth,b.stageWidth,b.scrollbarStageWidth,b.scrollMargin,b.scrollBorder,b.originalOffsets,b.childrenOffsets,b.slideNodeOuterWidths,b.sliderNumber,b.infiniteSliderWidth,b.numberOfSlides,b.centeredSlideOffset,b.settings);x[b.sliderNumber]= c})},prevSlide:function(){return this.each(function(){var c=a(this).data("iosslider");if(void 0==c)return!1;var f=(x[c.sliderNumber]+F[c.sliderNumber]+c.numberOfSlides)%c.numberOfSlides;(0<f||c.settings.infiniteSlider)&&e.changeSlide(f-1,a(c.scrollerNode),a(c.slideNodes),$[c.sliderNumber],c.scrollbarClass,c.scrollbarWidth,c.stageWidth,c.scrollbarStageWidth,c.scrollMargin,c.scrollBorder,c.originalOffsets,c.childrenOffsets,c.slideNodeOuterWidths,c.sliderNumber,c.infiniteSliderWidth,c.numberOfSlides, c.centeredSlideOffset,c.settings);x[c.sliderNumber]=f})},nextSlide:function(){return this.each(function(){var c=a(this).data("iosslider");if(void 0==c)return!1;var f=(x[c.sliderNumber]+F[c.sliderNumber]+c.numberOfSlides)%c.numberOfSlides;(f<c.childrenOffsets.length-1||c.settings.infiniteSlider)&&e.changeSlide(f+1,a(c.scrollerNode),a(c.slideNodes),$[c.sliderNumber],c.scrollbarClass,c.scrollbarWidth,c.stageWidth,c.scrollbarStageWidth,c.scrollMargin,c.scrollBorder,c.originalOffsets,c.childrenOffsets, c.slideNodeOuterWidths,c.sliderNumber,c.infiniteSliderWidth,c.numberOfSlides,c.centeredSlideOffset,c.settings);x[c.sliderNumber]=f})},lock:function(){return this.each(function(){var c=a(this).data("iosslider");if(void 0==c)return!1;fa[c.sliderNumber]=!0})},unlock:function(){return this.each(function(){var c=a(this).data("iosslider");if(void 0==c)return!1;fa[c.sliderNumber]=!1})},getData:function(){return this.each(function(){var c=a(this).data("iosslider");return void 0==c?!1:c})},autoSlidePause:function(){return this.each(function(){var c= a(this).data("iosslider");if(void 0==c)return!1;S[c.sliderNumber].autoSlide=!1;e.autoSlidePause(c.sliderNumber);return c})},autoSlidePlay:function(){return this.each(function(){var c=a(this).data("iosslider");if(void 0==c)return!1;S[c.sliderNumber].autoSlide=!0;e.autoSlide(a(c.scrollerNode),a(c.slideNodes),$[c.sliderNumber],c.scrollbarClass,c.scrollbarWidth,c.stageWidth,c.scrollbarStageWidth,c.scrollMargin,c.scrollBorder,c.originalOffsets,c.childrenOffsets,c.slideNodeOuterWidths,c.sliderNumber,c.infiniteSliderWidth, c.numberOfSlides,c.centeredSlideOffset,c.settings);return c})}};a.fn.iosSlider=function(c){if(V[c])return V[c].apply(this,Array.prototype.slice.call(arguments,1));if("object"===typeof c||!c)return V.init.apply(this,arguments);a.error("invalid method call!")}})(jQuery);