<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="apple-mobile-web-app-capable" content="yes">
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<div class="site">
		<header id="header" class="header-01">
			<div id="header-holder">
				<div class="container">
					<div class="table-row">
						<div class="table-cell text-left">
							<?php global $curly; echo $curly->get_logo(); ?>
						</div>
						<div class="table-cell">
							<nav role="navigation" id="navigation" class="text-right">
								<?php wp_nav_menu(array('theme_location' => 'menuMainMenu')); ?>
							</nav>
						</div>
					</div>
				</div>
			</div>
		</header>
		
		<?php get_template_part( 'template-parts/heading' ); ?>
		
		<?php get_template_part( 'template-parts/before-posts', 'sort' ); ?>