<?php

/*	Definitions
	================================================= */
	
	// Theme Name
	if ( !defined('THEMENAME') ) {
		define( 'THEMENAME', 'Equestrian' );
	}
	
	// Theme Prefix
	if ( !defined('THEMEPREFIX') ) {
		define('THEMEPREFIX', 'eque');
	}
	
	// Admin Name
	if ( !defined('ADMINNAME') ) {
		define( 'ADMINNAME', ( ( get_option(THEMEPREFIX.'_theme_options_name', 'Equestrian Options') != null ) ? get_option( THEMEPREFIX.'_theme_options_name', 'Equestrian Options' ) : 'Theme Options') );
	}

/*	Theme Update
	================================================= */	
	
	if ( get_option( THEMEPREFIX.'_theme_options_username', null ) && get_option( THEMEPREFIX.'_theme_options_api', null ) ) {
		load_template( trailingslashit( get_template_directory() ) . 'framework/theme-update/envato-wp-theme-updater.php' );
		Envato_WP_Theme_Updater::init( get_option( THEMEPREFIX.'_theme_options_username', null ), get_option( THEMEPREFIX.'_theme_options_api', null ), 'Curly Themes' );	
	}

/*	Theme Navigation
	================================================= */	
	register_nav_menus( array(
		'menuMainMenu' => 'Main Menu'
	));

/*	Sidebars
	================================================= */	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Sidebar - Blog', 'CURLYTHEME'),
		'id'			 => 'sidebar_blog',
		'before_widget'	 => '<div id="%1$s" class="sidebar-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h5 class="special-title"><span>',
		'after_title'	 => '</span></h5>',
	));
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Sidebar - Page' , 'CURLYTHEME'),
		'id'			 => 'sidebar_page',
		'before_widget'	 => '<div id="%1$s" class="sidebar-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h5 class="special-title"><span>',
		'after_title'	 => '</span></h5>',
	));
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Pre-Footer Left' , 'CURLYTHEME'),
		'id'			 => 'pre_footer_sidebar_left',
		'before_widget'	 => '<div id="%1$s" class="col-lg-8 col-md-8 pre-footer-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h4 class="special-title"><span>',
		'after_title'		 => '</span></h4>',
	));	
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Pre-Footer Right' , 'CURLYTHEME'),
		'id'			 => 'pre_footer_sidebar_right',
		'before_widget'	 => '<div id="%1$s" class="col-lg-4 col-md-4 pre-footer-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h4 class="special-title"><span>',
		'after_title'		 => '</span></h4>',
	));	
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Footer Left Sidebar' , 'CURLYTHEME'),
		'id'			 => 'footer_sidebar_left',
		'before_widget'	 => '<div id="%1$s" class="col-lg-5 col-md-5 col-sm-4 footer-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h5 class="special-title"><span>',
		'after_title'		 => '</span></h5>',
	));	
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Footer Center Sidebar' , 'CURLYTHEME'),
		'id'			 => 'footer_sidebar_center',
		'before_widget'	 => '<div id="%1$s" class="col-lg-4 col-md-4 col-sm-4 footer-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h5 class="special-title"><span>',
		'after_title'		 => '</span></h5>',
	));	
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => __('Footer Right Sidebar', 'CURLYTHEME'),
		'id'			 => 'footer_sidebar_right',
		'before_widget'	 => '<div id="%1$s" class="col-lg-3 col-md-3 col-sm-4 footer-widget %2$s">',
		'after_widget' 	 => '</div>',
		'before_title'	 => '<h5 class="special-title"><span>',
		'after_title'		 => '</span></h5>',
	));	
	
	if ( function_exists('register_sidebar'))
		register_sidebar(array(
		'name'			 => 'Absolute Footer',
		'id'			 => 'absolute_footer',
		'before_widget'	 => '',
		'after_widget' 	 => '',
		'before_title'	 => '',
		'after_title'	 => '',
	));	
	
	if ( class_exists('bbPress') ) {
		if ( function_exists('register_sidebar'))
			register_sidebar(array(
			'name'			 => __('Forum Sidebar' , 'CURLYTHEME'),
			'id'			 => 'sidebar_forum',
			'before_widget'	 => '<div id="%1$s" class="sidebar-widget %2$s">',
			'after_widget' 	 => '</div>',
			'before_title'	 => '<h5 class="special-title"><span>',
			'after_title'		 => '</h5>',
		));
	}
	
/*	Theme Localization
	================================================= */
	function curly_theme_localization() {
	    load_theme_textdomain('CURLYTHEME', get_template_directory() . '/languages');
	}
	add_action('after_setup_theme', 'curly_theme_localization');
	
/*	Content Width
	================================================= */	
	if ( ! isset( $content_width ) ) { 
		$content_width = 670; 
	}

/*	Add Theme Support
	================================================= */	
	add_theme_support('post-thumbnails', array('post'));	
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'custom-background' );
	$defaults_header = array(
		'random-default'         => true,
		'width'                  => 1600,
		'height'                 => 500,
		'header-text'            => false,
		'uploads'                => true
	);
	add_theme_support( 'custom-header', $defaults_header );

/*	Add General Filters
	================================================= */	
	add_filter('widget_text', 'do_shortcode');
	
/*	Load Scripts & Styles
	================================================= */
	function curly_load_theme_scripts(){
		if (!is_admin()) {
			
			// Register Styles
			wp_register_style( 'curly-bootstrap-css', get_template_directory_uri() . '/css/bootstrap.min.css', null, null, 'all'); 
			wp_register_style( 'curly-fontawesome', '//netdna.bootstrapcdn.com/font-awesome/4.0.3/css/font-awesome.min.css', null, null, 'all');
			wp_register_style( 'curly-flip', get_template_directory_uri() . '/css/flip.css', null, null, 'all');
			wp_register_style( 'curly-animate', get_template_directory_uri() . '/css/animate.min.css', null, null, 'all');
			wp_register_style( 'curly-style', get_stylesheet_uri(), array('curly-bootstrap-css', 'curly-fontawesome', 'curly-flip'), null, 'all');
			
			// Register Styles
			wp_register_script('curly-google-maps', '//maps.google.com/maps/api/js?sensor=false&amp;language=en', null, null, true);
			wp_register_script('curly-gmap3', get_template_directory_uri() .'/js/gmap3.js', array('curly-google-maps'), null, true);
		
			// Enqueue Scripts
			wp_enqueue_script('curly-bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), null, true);
			wp_enqueue_script('curly-dropdown', get_template_directory_uri() . '/js/dropdown-menu.min.js', array('jquery'), null, true);
			wp_enqueue_script('curly-vertical-align', get_template_directory_uri() . '/js/jquery.flexverticalcenter.js', array('jquery'), null, true);
			wp_enqueue_script('curly-equalize', get_template_directory_uri() . '/js/equalize.min.js', array('jquery'), null, true);
			wp_enqueue_script('curly-hoverint', get_template_directory_uri() . '/js/jquery.hoverIntent.minified.js', array('jquery'), null, true);
			wp_enqueue_script('curly-waypoints', get_template_directory_uri() . '/js/waypoints.min.js', array('jquery'), null, true);
			wp_enqueue_script('curly-waypoints-sticky', get_template_directory_uri() . '/js/waypoints-sticky.min.js', array('jquery'), null, true);
			wp_enqueue_script('curly-doubletap', get_template_directory_uri() . '/js/doubletaptogo.js', array('jquery'), null, true);
			wp_enqueue_script('curly-main', get_template_directory_uri() . '/js/main.js', array('jquery'), null, true);
			$translation_array = array( 
				'color_menu_text' => get_option(THEMEPREFIX.'_color_menu_text', '#FFF') , 
				'color_menu_text_hover' => get_option(THEMEPREFIX.'_color_menu_hover_text', '#E09C95'),
				'sticky_menu' => get_option( THEMEPREFIX.'_sticky_menu', false ),
				'responsive' => get_option( THEMEPREFIX.'_general_responsive', 'true' ),
				'menu_hover' => get_option( THEMEPREFIX.'_hover_menu', false ),
				'animations' => get_option( THEMEPREFIX.'_general_animations', null )
			);
			wp_localize_script( 'curly-main', 'data', $translation_array );

			// Enqueue Styles
			wp_enqueue_style('curly-bootstrap-css');
			wp_enqueue_style('curly-fontawesome');
			wp_enqueue_style('curly-flip');
			wp_enqueue_style('curly-style');
			
			if( get_option( THEMEPREFIX.'_general_animations', null ) != "true" ){ 
				wp_enqueue_style('curly-animate');
			}
			
			$GLOBALS['wp_styles']->add_data( 'ie8fixes', 'conditional', 'lte IE 8' );
			wp_enqueue_style( 'curly-ie8fixes' );
			   
			// Custom CSS
			load_template( trailingslashit( get_template_directory() ) . 'css/dynamic-css.php' );  
			
			wp_add_inline_style( 'curly-style', CurlyThemes::minify_css( htmlspecialchars_decode( curly_custom_css() ).curly_individual_page_settings_css() ) ); 
		}
	}
	add_action('wp_enqueue_scripts', 'curly_load_theme_scripts');

/*	Enqueue Admin Scripts
    ================================================= */    	
	function curly_admin_enqueue($hook) {	
		wp_enqueue_script('thickbox');
	 	wp_enqueue_style('thickbox');
	 	if ( in_array( get_current_screen()->id, get_post_types()) ) {
	 		wp_enqueue_style('curly-meta-boxes-css', get_template_directory_uri() . '/framework/meta-boxes/css/meta-boxes.css', null, null, 'all');
	 		wp_enqueue_style( 'wp-color-picker' );	
	 		wp_enqueue_media();
	 		wp_enqueue_script('jquery-ui-core');
	 		wp_enqueue_script('jquery-ui-tabs');
	 		wp_enqueue_script('jquery-ui-widget');
	 		wp_enqueue_script('jquery-ui-mouse');
	 		wp_enqueue_script('wp-color-picker');
	 		
	 		// Get Current Color Scheme
	 		global $_wp_admin_css_colors; 
	 		$admin_colors = $_wp_admin_css_colors;
	 		$color_scheme = $admin_colors[get_user_option('admin_color')]->colors;
	 		
	 		$color_scheme = '
	 			#individual-page-settings .form-control .slider.ui-slider .ui-slider-handle{
	 				background: '.$color_scheme[3].';
	 			}
	 			#individual-page-settings-wrapper > ul > li.ui-state-active > a{
	 				border-left: 5px solid '.$color_scheme[3].';
	 				border-top-color: '.$color_scheme[3].';
	 				padding-left: 15px;
	 			}';
	 		
	 		wp_add_inline_style('curly-meta-boxes-css', $color_scheme);
	 	}
	}
	add_action( 'admin_enqueue_scripts', 'curly_admin_enqueue' );	
	
	
/*	Equestrian Menu Walker
	================================================= */		
	function curly_add_menu_parent_class( $items ) {
		
		$parents = array();
		foreach ( $items as $item ) {
			if ( $item->menu_item_parent && $item->menu_item_parent > 0 ) {
				$parents[] = $item->menu_item_parent;
			}
		}
		
		foreach ( $items as $item ) {
			if ( in_array( $item->ID, $parents ) ) {
				$item->classes[] = 'menu-parent-item'; 
			}
		}
		
		return $items;    
	}
	add_filter( 'wp_nav_menu_objects', 'curly_add_menu_parent_class' );

/*	Function curly_is_blog()
	================================================= */	
	function curly_is_blog() { 
		global  $post; $posttype = get_post_type($post);
		if ( ((is_archive()) || (is_author()) || (is_category()) || (is_home()) || (is_single()) || (is_tag())) && ( $posttype == 'post') ) { 
			return true;
		} else { 
			return false; 
		} 
	}
	
/*	Individual Page Settings
	================================================= */
	load_template( trailingslashit( get_template_directory() ) . 'framework/meta-boxes/framework.individual-page-settings.php' );
	
/*	Admin Customizer
	================================================= */
	load_template( trailingslashit( get_template_directory() ) . 'framework/framework.admin-customizer.php' );

/*	Load Plugins
	================================================= */
	load_template( trailingslashit( get_template_directory() ) . 'framework/framework.plugins.php' );

/*	Get Comments
	================================================= */
	load_template( trailingslashit( get_template_directory() ) . 'framework/framework.comments.php' );	
	
/*	Load Equestrian Options Panel
	================================================= */
	load_template( trailingslashit( get_template_directory() ) . 'admin/admin-page.php' );
	
	/** Include the $options array */
	include( trailingslashit( get_template_directory() ) . 'admin/options.php' );
	
	/** Create the Options Page */
	$options_page = new WhitelabelOptions( 
		ADMINNAME, 			// Admin Name
		'theme-options', 	// Admin Page Slug
		THEMEPREFIX, 		// Prefix
		'themes.php', 		// Admin Page Parent
		null, 				// Admin Page Icon
		'read', 			// Admin Page User Roles
		null, 				// Admin Page Order
		true, 				// Admin Page Style
		false, 				// Admin Page Title
		false, 				// Generate Sidebar
		$options			// Options Array
	);
	
	function curly_theme_activation( $oldname, $oldtheme=false ) {
		include( get_template_directory().'/admin/options.php' );
		
		foreach ($options as $key => $option) {
			
			$id = isset( $option['id'] ) ? $option['id'] : null ;
			$default =  isset( $option['std'] ) ? $option['std'] : null ;
			
			switch ( $option['type'] ) {
				case 'text' 		: add_option( $id , $default ); break;
				case 'textarea' 	: add_option( $id , $default ); break;
				case 'checkbox' 	: add_option( $id , $default ); break;
				case 'select' 		: add_option( $id , $default ); break;
				case 'color' 		: add_option( $id , $default ); break;
				case 'upload'		: add_option( $id , $default ); break;
				case 'upload_min'	: add_option( $id , $default ); break;
				case 'number' 		: add_option( $id , $default ); break;
				case 'buttons' 		: add_option( $id , $default ); break;
				case 'images' 		: add_option( $id , $default ); break;
				case 'font' 		: {
					add_option( $id , $default[0] );
					add_option( $id . '_size' , $default[1] );
					add_option( $id . '_style' , $default[2] );
					add_option( $id . '_variant' , $default[3] );
				} break;
				case 'switch' 		: add_option( $id , $default ); break;
				case 'editor' 		: add_option( $id , $default ); break;
			}
		}
		
		// Font List
		add_option(THEMEPREFIX.'_json_font_list' , '{"0":[0,"Arial, Helvetica"],"1":[0,"Arial Black, Gadget"],"2":[0,"Comic Sans MS, cursive"],"3":[0,"Courier New, monospace"],"4":[0,"Georgia, serif"],"5":[0,"Impact, Charcoal"],"6":[0,"Lucida Console, Monaco, monospace"],"7":[0,"Lucida Sans Unicode, Lucida Grande"],"8":[0,"MS Sans Serif, Geneva"],"9":[0,"MS Serif, New York, serif"],"10":[0,"Palatino Linotype, Book Antiqua, Palatino, serif"],"11":[0,"Tahoma, Geneva"],"12":[0,"Times New Roman, Times, serif"],"13":[0,"Trebuchet MS"],"14":[0,"Abel"],"15":[1,"Anton"],"16":[1,"Arimo"],"17":[1,"Arvo"],"18":[1,"Asap"],"19":[1,"Bitter"],"20":[1,"Cabin"],"21":[1,"Cantarell"],"22":[1,"Changa One"],"23":[1,"Coming Soon"],"24":[1,"Crafty Girls"],"25":[1,"Cuprum"],"26":[1,"Dancing Script"],"27":[1,"Dosis"],"28":[1,"Droid Sans"],"29":[1,"Droid Serif"],"30":[1,"Exo"],"31":[1,"Francois One"],"32":[1,"Josefin Sans"],"33":[1,"Lato"],"34":[1,"Lobster"],"35":[1,"Lora"],"36":[1,"Maven Pro"],"37":[1,"Merriweather"],"38":[1,"Montserrat"],"39":[1,"Nobile"],"40":[1,"Nunito"],"41":[1,"Open Sans Condensed"],"42":[1,"Open Sans"],"43":[1,"Oswald"],"44":[1,"Oxygen"],"45":[1,"Pacifico"],"46":[1,"Play"],"47":[1,"PT Sans Narrow"],"48":[1,"PT Sans"],"49":[1,"PT Serif"],"50":[1,"Questrial"],"51":[1,"Raleway"],"52":[1,"Roboto Condensed"],"53":[1,"Roboto"],"54":[1,"Rokkitt"],"55":[1,"Shadows Into Light"],"56":[1,"Signika"],"57":[1,"Source Sans Pro"],"58":[1,"The Girl Next Door"],"59":[1,"Ubuntu Condensed"],"60":[1,"Ubuntu"],"61":[1,"Unkempt"],"62":[1,"Vollkorn"],"63":[1,"Yanone Kaffeesatz"],"64":[1,"Playfair Display"],"65":[1,"Playfair Display SC"],"66":[0,"Custom Uploaded Font"]}');
		
		// Color Scheme
		add_option(THEMEPREFIX.'_json_color_scheme', '{"default":{"text":"#1E1E1E","primary":"#c0392b","background":"#faf6f0","link":"#c0392b","linkHover":"#1E1E1E","h1":"#1E1E1E","h2":"#1E1E1E","h3":"#1E1E1E","h4":"#1E1E1E","h5":"#1E1E1E","h6":"#1E1E1E","menuLink":"#FFFFFF","menuHover":"#E09C95","menuBg":"#C0392B","submenuLink":"#33332E","submenuHover":"#c0392b","submenuBg":"#FFFFFF","footerText":"#a39b8d","footerLink":"#d3d1cf","footerTitle":"#FFFFFF"},"style1":{"text":"#1E1E1E","primary":"#3498db","background":"#faf6f0","link":"#2980b9","linkHover":"#1E1E1E","h1":"#1E1E1E","h2":"#1E1E1E","h3":"#1E1E1E","h4":"#1E1E1E","h5":"#1E1E1E","h6":"#1E1E1E","menuLink":"#FFFFFF","menuHover":"#a2cae0","menuBg":"#2980b9","submenuLink":"#33332E","submenuHover":"#2980b9","submenuBg":"#FFFFFF","footerText":"#a39b8d","footerLink":"#d3d1cf","footerTitle":"#FFFFFF"},"style2":{"text":"#1E1E1E","primary":"#27ae60","background":"#faf6f0","link":"#27ae60","linkHover":"#1E1E1E","h1":"#1E1E1E","h2":"#1E1E1E","h3":"#1E1E1E","h4":"#1E1E1E","h5":"#1E1E1E","h6":"#1E1E1E","menuLink":"#FFFFFF","menuHover":"#9be0b3","menuBg":"#27ae60","submenuLink":"#33332E","submenuHover":"#27ae60","submenuBg":"#FFFFFF","footerText":"#a39b8d","footerLink":"#d3d1cf","footerTitle":"#FFFFFF"},"style3":{"text":"#1E1E1E","primary":"#8e44ad","background":"#faf6f0","link":"#8e44ad","linkHover":"#1E1E1E","h1":"#1E1E1E","h2":"#1E1E1E","h3":"#1E1E1E","h4":"#1E1E1E","h5":"#1E1E1E","h6":"#1E1E1E","menuLink":"#FFFFFF","menuHover":"#dcc4e6","menuBg":"#8e44ad","submenuLink":"#33332E","submenuHover":"#8e44ad","submenuBg":"#FFFFFF","footerText":"#a39b8d","footerLink":"#d3d1cf","footerTitle":"#FFFFFF"},"style4":{"text":"#1E1E1E","primary":"#E67E22","background":"#faf6f0","link":"#E67E22","linkHover":"#1E1E1E","h1":"#1E1E1E","h2":"#1E1E1E","h3":"#1E1E1E","h4":"#1E1E1E","h5":"#1E1E1E","h6":"#1E1E1E","menuLink":"#FFFFFF","menuHover":"#F0E4D3","menuBg":"#E67E22","submenuLink":"#33332E","submenuHover":"#E67E22","submenuBg":"#FFFFFF","footerText":"#a39b8d","footerLink":"#d3d1cf","footerTitle":"#FFFFFF"},"style5":{"text":"#1E1E1E","primary":"#34495E","background":"#faf6f0","link":"#34495E","linkHover":"#1E1E1E","h1":"#1E1E1E","h2":"#1E1E1E","h3":"#1E1E1E","h4":"#1E1E1E","h5":"#1E1E1E","h6":"#1E1E1E","menuLink":"#FFFFFF","menuHover":"#99B4C8","menuBg":"#34495E","submenuLink":"#33332E","submenuHover":"#34495E","submenuBg":"#FFFFFF","footerText":"#a39b8d","footerLink":"#d3d1cf","footerTitle":"#FFFFFF"}}');
	}
	add_action("after_switch_theme", "curly_theme_activation", 10 ,  2);

/*	Curly Themes Core Class
	================================================= */
	include( trailingslashit( get_template_directory() ) . 'framework/classes/framework.class.core.php' );
	
/*	Generate Slider Class
	================================================= */
	include( trailingslashit( get_template_directory() ) . 'framework/classes/framework.class.slider.php' );  

/*	Get Value Class
	================================================= */	
	include( trailingslashit( get_template_directory() ) . 'framework/classes/framework.class.get-value.php' );

/*	Color Manipulation Class
	================================================= */	
	include( trailingslashit( get_template_directory() ) . 'framework/classes/framework.class.color.php' );
	
/*	Contact Side Class
	================================================= */
	include( trailingslashit( get_template_directory() ) . 'framework/classes/framework.class.contact.php' );

/*	Fonts Class
	================================================= */	
	include( trailingslashit( get_template_directory() ) . 'framework/classes/framework.class.fonts.php' );
	
	
/*	3rd Party Integration
	================================================= */

/*	WPML  */
	load_template( trailingslashit( get_template_directory() ) . 'framework/framework.wpml.php' );

/*	WooCommerce  */
	load_template( trailingslashit( get_template_directory() ) . 'framework/framework.woocommerce.php' );
	
?>