<?php

class CurlyMetaBoxOption {
	
	private $_id;
	private $_label;
	private $_default;
	private $_description;
	private $_array;
	private $_class;
	
	
	public function __construct( $id = null, $label = null, $default = null, $description = null, $array = null, $class = null ) {
		
		$this->_id = $id;
		$this->_label = $label;
		$this->_default = $default;
		$this->_description = $description;
		$this->_array = $array;
		$this->_class = $class;
		
	}
	
	public function checkbox( $html = null ) {
		$html .= '<div class="form-control checkbox '.$this->_class.'">';
			$html .= '<label for="'.$this->_id.'" class="name">'.$this->_label.'</label>';
			$html .= '<div>';
				$html .= '<label class="description"><input type="checkbox" name="'.$this->_id.'" id="'.$this->_id.'" value="true" '.checked( $this->_default, 'true' , false).' />';
				$html .= ( $this->_description ) ? $this->_description : null;
				$html .= '</label>';
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
	public function select( $html = null ) {
		$html .= '<div class="form-control select '.$this->_class.'">';
			$html .= '<label for="'.$this->_id.'" class="name">'.$this->_label.'</label>';
			$html .= '<div>';
				$html .= '<select class="select" name="'.$this->_id.'" id="'.$this->_id.'">';
				
					foreach ($this->_array as $value) {
						$html .= '<option value="'.$value['value'].'" '.selected( $this->_default, $value['value'], false ).'>';
						$html .= $value['name'];
						$html .= '</option>';
					}
				
				$html .= '</select>';
				$html .= ( $this->_description ) ? '<span class="description">'.$this->_description.'</span>' : null;
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
	public function color( $html = null ) {
		$html .= '<div class="form-control color '.$this->_class.'">';
			$html .= '<label for="'.$this->_id.'" class="name">'.$this->_label.'</label>';
			$html .= '<div>';
				$html .= '<input class="color-picker" type="text" name="'.$this->_id.'" id="'.$this->_id.'" value="'.$this->_default.'" />';
				$html .= ( $this->_description ) ? '<span class="description">'.$this->_description.'</span>' : null;
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
	public function image( $html = null ) {
		
		$clear_style = ( $this->_default ) ? 'style="display:inline-block"' : 'style="display:none"';
	
		$html .= '<div class="form-control image-field '.$this->_class.'">';
			$html .= '<label for="'.$this->_id.'" class="name">'.$this->_label.'</label>';
			$html .= '<div>';
				$html .= '<input type="hidden" name="'.$this->_id.'_id" id="'.$this->_id.'_id" value="'.$this->_default[0].'">';
				$html .= '<input class="text-field" type="text" name="'.$this->_id.'" id="'.$this->_id.'" value="'.$this->_default[1].'" />';
				$html .= '<a href="#" class="image-upload-button button button-primary button-large" data-upload-title="'.$this->_array['upload_title'].'" data-upload-button="'.$this->_array['upload_button'].'">'.$this->_array['upload_link'].'</a>';
				$html .= '<a href="#" class="image-clear-button button button-large" '.$clear_style.'>'.$this->_array['clear_link'].'</a>';
				$html .= ( isset( $this->_default[1] ) ) ? '<img src="'.$this->_default[1].'" class="image-preview" />' : null;
				$html .= ( $this->_description ) ? '<span class="description">'.$this->_description.'</span>' : null;
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
	public function slider( $html = null ) {
		$html .= '<div class="form-control">';
			$html .= '<label for="'.$this->_id.'" class="name">'.$this->_label.'</label>';
			$html .= '<div style="position: relative;">';
				$html .= '<input type="hidden" name="'.$this->_id.'" id="'.$this->_id.'" value="'.$this->_default.'" />';
				$html .= '<div class="slider" id="'.$this->_id.'_slider"></div>';
				$html .= '<div class="slider_value">'.(( $this->_default ) ? $this->_default.$this->_array['suf'] :  null ).'</div>';
				$html .= ( $this->_description ) ? '<span class="description">'.$this->_description.'</span>' : null;
				$html .= '<script type="text/javascript">';
					$html .= 'jQuery(function() { 
									jQuery( "#'.$this->_id.'_slider" ).slider({ 
										value: '.$this->_default.' , 
										step: '.$this->_array['step'].' , 
										min: '.$this->_array['min'].' , 
										max: '.$this->_array['max'].' , 
										slide: function( event, ui ) { 
											jQuery(this).siblings(".slider_value").text( ui.value + "'.$this->_array['suf'].'" );
											jQuery(this).siblings("input[type=hidden]").val(ui.value); 
										}
									}); 
								});';
				$html .= '</script>';
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
	public function editor( $html = null ) {
		
		ob_start(); wp_editor( $this->_default , $this->_id, array('textarea_rows' => 10 , 'teeny' => true) );
		
		$html .= '<div class="form-control">';
			$html .= '<label for="'.$this->_id.'" class="name">'.$this->_label.'</label>';
			$html .= '<div>';
				$html .= ob_get_clean();
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
	public function input( $html = null ) {
		$html .= '<div class="form-control">';
			$html .= '<label for="'.$this->_id.'" class="name">'.$this->_label.'</label>';
			$html .= '<div>';
				$html .= '<input class="text-field" type="text" name="'.$this->_id.'" id="'.$this->_id.'" value="'.$this->_default.'" />';
				$html .= ( $this->_description ) ? '<span class="description">'.$this->_description.'</span>' : null;
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
	public function radio( $html = null ) {
		$selected = ( $this->_default ) ? $this->_default : $this->_array[0]['value'];
		$html .= '<div class="form-control radio">';
			$html .= '<label for="'.$this->_id.'" class="name">'.$this->_label.'</label>';
			$html .= '<div>';
			
				foreach ($this->_array as $value) {
					$html .= '<label>';
						$html .= '<input type="radio" name="'.$this->_id.'" id="'.$value['id'].'" value="'.$value['value'].'" '.checked( $selected, $value['value'], false ).' />';
						$html .= $value['name'];
					$html .= '</label>';
				}
				
				$html .= ( $this->_description ) ? '<span class="description">'.$this->_description.'</span>' : null;
			$html .= '</div>';
		$html .= '</div>';
		
		echo $html;
	}
	
}


// Meta Data Box
add_action( 'add_meta_boxes', 'curly_individual_page_settings' );
function curly_individual_page_settings()
{	
	$post_types = get_post_types();
	
	foreach ($post_types as $post_type) {
		add_meta_box( 'individual-page-settings', 'Individual Page Settings', 'curly_individual_page_settings_cb', $post_type, 'normal', 'high' );
	}
}

// Meta Data Form
function curly_individual_page_settings_cb( $post )
{

	// Check if is Contact Page
	function curly_check_contact_page_template( $post_id ) {
		
		$template_file = get_post_meta( $post_id, '_wp_page_template', TRUE);
		
		if ( $template_file == 'page-templates/contact.php' || $template_file == 'page-templates/contact-2.php' || $template_file == 'page-templates/contact-3.php' ) {
			return true;
		} else {
			return false;
		}
	}
	
	// Default Values
	$values				= get_post_custom( $post->ID );
	$seo_title 			= isset( $values[THEMEPREFIX.'_seo_title'] ) ? esc_attr( $values[THEMEPREFIX.'_seo_title'][0] ) : null;
	$seo_description 	= isset( $values[THEMEPREFIX.'_seo_description'] ) ? esc_attr( $values[THEMEPREFIX.'_seo_description'][0] ) : null;
	$bg_color 			= isset( $values[THEMEPREFIX.'_bg_color'] ) ? esc_attr( $values[THEMEPREFIX.'_bg_color'][0] ) : null;
	$bg_img 			= isset( $values[THEMEPREFIX.'_bg_image'] ) ? esc_attr( $values[THEMEPREFIX.'_bg_image'][0] ) : null;
	$bg_img_id 			= isset( $values[THEMEPREFIX.'_bg_image_id'] ) ? $values[THEMEPREFIX.'_bg_image_id'][0] : null;
	$bg_pos 			= isset( $values[THEMEPREFIX.'_bg_position'] ) ? $values[THEMEPREFIX.'_bg_position'][0] : null;
	$bg_rep 			= isset( $values[THEMEPREFIX.'_bg_repeat'] ) ? $values[THEMEPREFIX.'_bg_repeat'][0] : null;
	$bg_size 			= isset( $values[THEMEPREFIX.'_bg_size'] ) ? $values[THEMEPREFIX.'_bg_size'][0] : null;
	$bg_att 			= isset( $values[THEMEPREFIX.'_bg_attachment'] ) ? $values[THEMEPREFIX.'_bg_attachment'][0] : null;
	$header_text		= isset( $values[THEMEPREFIX.'_header_text'] ) ? esc_attr( $values[THEMEPREFIX.'_header_text'][0] ) : null;
	$header_bg 			= isset( $values[THEMEPREFIX.'_header_bg_color'] ) ? esc_attr( $values[THEMEPREFIX.'_header_bg_color'][0] ) : null;
	$header_opac 		= isset( $values[THEMEPREFIX.'_header_opacity'] ) ? $values[THEMEPREFIX.'_header_opacity'][0] : get_option( THEMEPREFIX . '_header_shading_opacity', 55 );
	$header_img 		= isset( $values[THEMEPREFIX.'_header_image'] ) ? esc_attr( $values[THEMEPREFIX.'_header_image'][0] ) : null;
	$header_img_id 		= isset( $values[THEMEPREFIX.'_header_image_id'] ) ? esc_attr( $values[THEMEPREFIX.'_header_image_id'][0] ) : null;
	$header_lg 			= isset( $values[THEMEPREFIX.'_header_image_large'] ) ? esc_attr( $values[THEMEPREFIX.'_header_image_large'][0] ) : null;
	$header_top 		= isset( $values[THEMEPREFIX.'_header_margin_top'] ) ? $values[THEMEPREFIX.'_header_margin_top'][0]  : get_option( THEMEPREFIX . '_header_margin_top', 55 );
	$header_bot 		= isset( $values[THEMEPREFIX.'_header_margin_bottom'] ) ? $values[THEMEPREFIX.'_header_margin_bottom'][0]  : get_option( THEMEPREFIX . '_header_margin_bottom', 75 );
	$heading_color		= isset( $values[THEMEPREFIX.'_heading_color'] ) ? esc_attr( $values[THEMEPREFIX.'_heading_color'][0] ) : null;
	$bc					= isset( $values[THEMEPREFIX.'_breadcrumbs'] ) ? esc_attr( $values[THEMEPREFIX.'_breadcrumbs'][0] ) : null;
	$heading			= isset( $values[THEMEPREFIX.'_heading'] ) ? esc_attr( $values[THEMEPREFIX.'_heading'][0] ) : null;
	$slider_push		= isset( $values[THEMEPREFIX.'_slider_push'] ) ? esc_attr( $values[THEMEPREFIX.'_slider_push'][0] ) : null;
	$sidebar			= isset( $values[THEMEPREFIX.'_sidebar'] ) ? esc_attr( $values[THEMEPREFIX.'_sidebar'][0] ) : null;
	
	// Old Header Image
	if ( empty( $header_img ) ) {
		$header_img = isset( $values[THEMEPREFIX.'page_settings_heading_image'][0] ) ? $values[THEMEPREFIX.'page_settings_heading_image'][0] : null;
	}
	if ( empty( $header_img_id ) ) {
		$header_img_id = isset( $values[THEMEPREFIX.'page_settings_heading_image_id'][0] ) ? $values[THEMEPREFIX.'page_settings_heading_image_id'][0] : null;
	}
	if ( empty( $header_lg ) ) {
		$header_lg  = isset( $values['large_header'][0] ) ? $values['large_header'][0] : null;
	}
	
	// Slider Builder
	$slider	= isset( $values[THEMEPREFIX.'_slider'] ) ? $values[THEMEPREFIX.'_slider'][0] : null;
	if ( empty( $slider ) ) {
		$slider	= isset( $values['slider'] ) ? $values['slider'][0] : null;
	}
	$slider_shortcode = isset( $values[THEMEPREFIX.'_slider_shortcode'] ) ? $values[THEMEPREFIX.'_slider_shortcode'][0] : null;
	if ( empty( $slider_shortcode ) ) {
		$slider_shortcode	= isset( $values['slider_shortcode'] ) ? $values['slider_shortcode'][0] : null;
	}
	if ( strlen($slider_shortcode) >= 5 ) {
		preg_match('/id=\"(\d+)\"/', $slider_shortcode, $matches);
		if ( $matches ) {
			$slider_shortcode = $matches[1];
		}
	}
	$slider_text_color	= isset( $values[THEMEPREFIX.'_slider_text_color'] ) ? $values[THEMEPREFIX.'_slider_text_color'][0] : null;
	if ( empty( $slider_text_color ) ) {
		$slider_text_color	= isset( $values['slider_text_color'] ) ? $values['slider_text_color'][0] : null;
	}
	$slider_color	= isset( $values[THEMEPREFIX.'_slider_color'] ) ? $values[THEMEPREFIX.'_slider_color'][0] : null;
	if ( empty( $slider_color ) ) {
		$slider_color	= isset( $values['slider_color'] ) ? $values['slider_color'][0] : null;
	}
	$slider_titles	= isset( $values[THEMEPREFIX.'_slides_titles'] ) ? unserialize($values[THEMEPREFIX.'_slides_titles'][0]) : null;
	if ( empty( $slider_titles ) ) {
		$slider_titles	= isset( $values['slides_title'] ) ? unserialize($values['slides_title'][0] ) : null;
	}
	$slider_subtitles	= isset( $values[THEMEPREFIX.'_slides_subtitles'] ) ? unserialize($values[THEMEPREFIX.'_slides_subtitles'][0]) : null;
	if ( empty( $slider_titles ) ) {
		$slider_subtitles	= isset( $values['slides_subtitle'] ) ? unserialize($values['slides_subtitle'][0] ) : null;
	}
	$slider_links	= isset( $values[THEMEPREFIX.'_slides_links'] ) ? unserialize($values[THEMEPREFIX.'_slides_links'][0]) : null;
	if ( empty( $slider_links ) ) {
		$slider_links	= isset( $values['slides_link'] ) ? unserialize($values['slides_link'][0] ) : null;
	}
	$slider_images	= isset( $values[THEMEPREFIX.'_slides_images'] ) ? unserialize($values[THEMEPREFIX.'_slides_images'][0]) : null;
	if ( empty( $slider_images ) ) {
		$slider_images	= isset( $values['slides_images'] ) ? unserialize($values['slides_images'][0] ) : null;
	}
	
	// Contact Page Values
	if ( curly_check_contact_page_template( $post->ID ) ){
	
		// Default Values
		$contact_side		= isset( $values[THEMEPREFIX.'_contact_side'] ) ? $values[THEMEPREFIX.'_contact_side'][0] : null;
		$latitude			= isset( $values[THEMEPREFIX.'_latitude'] ) ? $values[THEMEPREFIX.'_latitude'][0] : null;
		$longitude			= isset( $values[THEMEPREFIX.'_longitude'] ) ? $values[THEMEPREFIX.'_longitude'][0] : null;
		$map_type			= isset( $values[THEMEPREFIX.'_map_type'] ) ? $values[THEMEPREFIX.'_map_type'][0] : null;
		$map_height			= isset( $values[THEMEPREFIX.'_map_height'] ) ? $values[THEMEPREFIX.'_map_height'][0] : null;
		$map_zoom			= isset( $values[THEMEPREFIX.'_map_zoom'] ) ? $values[THEMEPREFIX.'_map_zoom'][0] : null;
		$map_color			= isset( $values[THEMEPREFIX.'_map_color'] ) ? $values[THEMEPREFIX.'_map_color'][0] : null;
		$map_marker			= isset( $values[THEMEPREFIX.'_map_marker'] ) ? $values[THEMEPREFIX.'_map_marker'][0] : null;
		
		// Old Values
		if ( empty( $contact_side ) ) {
			$contact_side = isset( $values[THEMEPREFIX.'contact_side'] ) ? $values[THEMEPREFIX.'contact_side'][0] : null;
		}
		if ( empty( $latitude ) ) {
			$latitude = isset( $values[THEMEPREFIX.'latitude'] ) ? $values[THEMEPREFIX.'latitude'][0] : null;
		}
		if ( empty( $longitude ) ) {
			$longitude = isset( $values[THEMEPREFIX.'longitude'] ) ? $values[THEMEPREFIX.'longitude'][0] : null;
		}
		if ( empty( $map_type ) ) {
			$map_type = isset( $values[THEMEPREFIX.'map_type'] ) ? $values[THEMEPREFIX.'map_type'][0] : null;
		}
		if ( empty( $map_height ) ) {
			$map_height = isset( $values[THEMEPREFIX.'map_height'] ) ? $values[THEMEPREFIX.'map_height'][0] : 500;
		}
		if ( empty( $map_zoom ) ) {
			$map_zoom = isset( $values[THEMEPREFIX.'map_zoom'] ) ? $values[THEMEPREFIX.'map_zoom'][0] : 15;
		}
		if ( empty( $map_color ) ) {
			$map_color = isset( $values[THEMEPREFIX.'map_color'] ) ? $values[THEMEPREFIX.'map_color'][0] : null;
		}
		if ( empty( $map_marker ) ) {
			$map_marker = isset( $values[THEMEPREFIX.'map_marker'] ) ? $values[THEMEPREFIX.'map_marker'][0] : null;
		}
	}
	
	// Old Values
	if ( empty( $seo_title ) ) { 
		$seo_title = isset( $values['seotitle'] ) ? esc_attr( $values['seotitle'][0] ) : null; 
	}
	if ( empty( $seo_description ) ) { 
		$seo_description = isset( $values['seodescription'] ) ? esc_attr( $values['seodescription'][0] ) : null;
	}
	if ( empty( $heading ) ) {
		$heading = isset( $values[THEMEPREFIX.'page_heading'] ) ? esc_attr( $values[THEMEPREFIX.'page_heading'][0] ) : null;
	}
	if ( empty( $slider_push ) ) {
		$slider_push = isset( $values[THEMEPREFIX.'header_push'] ) ? esc_attr( $values[THEMEPREFIX.'header_push'][0] ) : null;
	}
	
	// All in One Seo Compatibility
	if ( empty( $seo_title ) ) { 
		$seo_title = isset( $values['_aioseop_title'] ) ? esc_attr( $values['_aioseop_title'][0] ) : null;
	}
	if ( empty( $seo_description ) ) { 
		$seo_description = isset( $values['_aioseop_description'] ) ? esc_attr( $values['_aioseop_description'][0] ) : null;
	}
	
	// Default data
	if ( empty( $seo_title ) ) {
	
		$seo_title = get_the_title();
		$seo_title = (strlen($seo_title) >= 70) ? substr($seo_title, 0, 70).' ...' : $seo_title;
	}
	if ( empty( $seo_description ) ) { 
		$seo_description = substr(strip_tags(do_shortcode($post->post_content)), 0, 160);
		$seo_description = str_replace("\r\n","",$seo_description).' ...';
	}
	
	wp_nonce_field( 'my_meta_box_nonce', 'meta_box_nonce' );
	?>
	
    <div id="individual-page-settings-wrapper">
    
		<ul>
			<?php if ( curly_check_contact_page_template( $post->ID ) ) : ?>
			<li><a href="#contact"><?php _e('Contact Details', 'CURLYTHEME'); ?></a></li>
			<?php endif; ?>
			<?php if ( get_option( THEMEPREFIX.'_seo' ) != "true" ) : ?>
			<li><a href="#seo"><?php _e('SEO Pro Panel', 'CURLYTHEME'); ?></a></li>
			<?php endif; ?>
			<?php if ( !curly_check_contact_page_template( $post->ID ) ) : ?>
			<li><a href="#slider"><?php _e('Slider Builder', 'CURLYTHEME'); ?></a></li>
			<?php endif; ?>
			<li><a href="#bg"><?php _e('Background Options', 'CURLYTHEME'); ?></a></li>
			<li><a href="#header"><?php _e('Header Options', 'CURLYTHEME'); ?></a></li>
			<li><a href="#page"><?php _e('Page options', 'CURLYTHEME'); ?></a></li>
			<li class="line"></li>
		</ul>
		
		<?php if ( curly_check_contact_page_template( $post->ID ) ) : ?>
		<div id="contact">
			<div>
				<?php 
				
					$object_side_content = new CurlyMetaBoxOption( THEMEPREFIX.'_contact_side' , __('Side Content:', 'CURLYTHEME') , $contact_side ); 
					$object_side_content->editor();
					
					$object_latitude = new CurlyMetaBoxOption( THEMEPREFIX.'_latitude' , __('Map Latitude:', 'CURLYTHEME') , $latitude , __('Latitude Coordinates (Please use decimal coordinates. ie. 51.508056)', 'CURLYTHEME') ); 
					$object_latitude->input(); 
					
					$object_longitude = new CurlyMetaBoxOption( THEMEPREFIX.'_longitude' , __('Map Longitude:', 'CURLYTHEME') , $longitude , __('Longitude Coordinates (Please use decimal coordinates. ie. -0.128056)', 'CURLYTHEME') ); 
					$object_longitude->input();
					
					$object_map_type = new CurlyMetaBoxOption( THEMEPREFIX.'_map_type' , __('Map Type:', 'CURLYTHEME') , $map_type , __('Choose your map type', 'CURLYTHEME') , array( array( 'id' => THEMEPREFIX . '_map_type_roadmap', 'name' => __('Roadmap', 'CURLYTHEME'), 'value' => 'roadmap' ), array( 'id' => THEMEPREFIX . '_map_type_satellite', 'name' => __('Satellite', 'CURLYTHEME'), 'value' => 'satellite' ), array( 'id' => THEMEPREFIX . '_map_type_hybrid', 'name' => __('Hybrid', 'CURLYTHEME'), 'value' => 'hybrid'), array('id' => THEMEPREFIX . '_map_type_terrain','name' => __('Terrain', 'CURLYTHEME'), 'value' => 'terrain') ) ); 
					$object_map_type->radio(); 
					
					$object_map_height = new CurlyMetaBoxOption( THEMEPREFIX.'_map_height' , __('Map Height:', 'CURLYTHEME') , $map_height , __('Choose the map height. Default is 500px.', 'CURLYTHEME') , array( 'step' => 1, 'min' => 100, 'max' => 800, 'suf' => 'px' ) ); 
					$object_map_height->slider(); 
					
					$object_map_zoom = new CurlyMetaBoxOption( THEMEPREFIX.'_map_zoom' , __('Map Zoom:', 'CURLYTHEME') , $map_zoom , __('Choose the map zoom level. Default level is 15', 'CURLYTHEME') , array( 'step' => 1, 'min' => 1, 'max' => 18, 'suf' => 'px' ) ); 
					$object_map_zoom->slider(); 
					
					$object_map_marker = new CurlyMetaBoxOption( THEMEPREFIX.'_map_marker' , __('Map Marker:', 'CURLYTHEME') , array( null , $map_marker) , __('Use this image to mark your location', 'CURLYTHEME') , array( 'upload_title' => __('Upload Map Marker', 'CURLYTHEME'), 'upload_button' => __('Insert Image', 'CURLYTHEME'), 'upload_link' => __('Upload Map Marker', 'CURLYTHEME') , 'clear_link' => __('Clear Map Marker', 'CURLYTHEME') ) ); 
					$object_map_marker->image(); 
					
					$object_map_color = new CurlyMetaBoxOption( THEMEPREFIX.'_map_color' , __('Map Color:', 'CURLYTHEME') , $map_color , __('Choose map saturation color. Leave Blank for Default colors. Map Saturation only works with map type set to roadmap or terrain', 'CURLYTHEME')); 
					$object_map_color->color(); 
				
				?>
				
			</div>
		</div><!-- end contact -->
		<?php endif; ?>
		
		<?php if ( get_option( THEMEPREFIX.'_seo' ) != "true" ) : ?>
		<div id="seo">
			<div>
				<div class="form-control">
					<label for="<?php echo THEMEPREFIX ?>_seo_title" class="name"><?php _e('SEO Meta Title:', 'CURLYTHEME'); ?></label>
					<div>
						<input class="text-field" type="text"  name="<?php echo THEMEPREFIX ?>_seo_title" id="<?php echo THEMEPREFIX ?>_seo_title" value="<?php echo $seo_title ?>" />
						<span class="description">
							<?php _e('Title should not have more than 70 characters.', 'CURLYTHEME'); ?>
							<strong class="pull-right <?php echo ( strlen($seo_title) > 70 ) ? 'red' : null ?>"><?php echo strlen($seo_title); ?></strong>
						</span>
					</div>
				</div>
				<div class="form-control">
					<label for="<?php echo THEMEPREFIX ?>_seo_description" class="name"><?php _e('SEO Meta Description:', 'CURLYTHEME'); ?></label>
					<div>
						<textarea class="textarea" name="<?php echo THEMEPREFIX ?>_seo_description" id="<?php echo THEMEPREFIX ?>_seo_description"><?php echo $seo_description ?></textarea>
						<span class="description">
							<?php _e('Description should not have more than 160 characters. ', 'CURLYTHEME'); ?>
							<strong class="pull-right <?php echo ( strlen($seo_description) > 160 ) ? 'red' : null ?>"><?php echo strlen($seo_description); ?></strong>
						</span>
					</div>
				</div>
				<div class="form-control">
					<label class="name"><?php _e('SEO Keyword Density:', 'CURLYTHEME'); ?></label>
					<div>
						<div class="keywords">
						<?php 
						
						load_template( trailingslashit( get_template_directory() ) . 'framework/classes/framework.keyword-density.php' );
						
						$page_content = wp_filter_nohtml_kses(wpautop(do_shortcode($post->post_content)));
						
						if ( strlen(trim($page_content)) > 0 ) {
							$density_array = calcDensity($page_content);
							
							$keywords = array();
							
							if ( count($density_array) < 10 ) {
								$limit = count($density_array) - 1;
							} else {
								$limit = 10;
							}
							
							for ( $i = 1; $i <= $limit; $i++ ) {
								if ( $density_array[$i]['percent'] >= 2.5 ) {
									echo '<span class="keyword red">'.$density_array[$i]['keyword'].': '.$density_array[$i]['percent'].'%</span>';
								} else {
									echo '<span class="keyword green">'.$density_array[$i]['keyword'].': '.$density_array[$i]['percent'].'%</span>';
								}
								array_push($keywords, $density_array[$i]['keyword']);
							}	
						} else {
							_e('Keyword density cannot be calculated. Please add some content.', 'CURLYTHEME');
						}
						?>
						</div>
						<span class="description"><?php _e('Please check your keyword density. Keyword density should not exceed 2.5%.', 'CURLYTHEME'); ?> <br><a href="http://en.wikipedia.org/wiki/Keyword_density" target="_blank"><?php _e('Learn more about keyword density', 'CURLYTHEME'); ?></a></span>
					</div>
				</div>
				<div class="form-control">
					<label class="name"><?php _e('Google SEO Tips:', 'CURLYTHEME'); ?></label>
					<div>
						<?php 
						
						$score = 50;
						
						$score += ( !empty($seo_title) ) ? 7 : 0;
						$score += ( strlen($seo_title) <= 70 ) ? 5 : 0;
						$score += ( !empty($seo_description) ) ? 7 : 0;
						$score += ( strlen($seo_description) <= 165 ) ? 5 : 0;
						$score += ( strpos($post->post_content, '<img') == true  ) ? 5 : 0 ;
						$score += ( str_word_count($post->post_content,0) >= 300 ) ? 6 : 0 ;
						$score += ( strpos($post->post_content, '<strong') == true && strpos($post->post_content, '<em') == true ) ? 5 : 0 ;
						
						$keyword_title = false;
						$keyword_description = false;
						
						if ( strlen(trim($page_content)) > 0 ) {
							foreach ($keywords as $keyword) {
								if ( strpos($seo_title, $keyword) ) {
									$keyword_title = true;
								}
							}
							
							foreach ($keywords as $keyword) {
								if ( strpos($seo_description, $keyword) ) {
									$keyword_description = true;
								}
							}
						}
						
						$score += ( $keyword_title == true ) ? 5 : 0 ;
						$score += ( $keyword_description == true ) ? 5 : 0 ;
						
						$color = 'red';
						
						if ( $score >= 85 ) {
							$color = 'green';
						} elseif ( $score > 65 ) {
							$color = 'orange';
						}
						
						?>
						<div id="seo-score" class="<?php echo $color; ?>">
							<div style="width: <?php echo $score; ?>%;" class="<?php echo $color; ?>">
								SEO Score <strong><?php echo $score; ?>%</strong>
							</div>
						</div>
						<ul class="tips-list">
							<?php echo ( $keyword_title == false ) ? '<li>'.__('None of your keywords can be found in the SEO Title.', 'CURLYTHEME').'</li>' : null; ?>
							<?php echo ( $keyword_description == false ) ? '<li>'.__('None of your keywords can be found in the SEO Description.', 'CURLYTHEME').'</li>' : null; ?>
							<?php echo ( str_word_count($post->post_content,0) < 300 ) ? sprintf('<li>Your copy has %s words witch is less than 300, the minimum reccomended.</li>', str_word_count($post->post_content,0)) : null; ?>
							<?php echo ( strpos($post->post_content, '<img') == false ) ? '<li>'.__('Please consider adding at least one image to your copy with an appropriate description.', 'CURLYTHEME').'</li>' : null; ?>
							<?php echo ( strpos($post->post_content, '<strong') == false || strpos($post->post_content, '<em') == false ) ? '<li>'.__('Please consider using &nbsp;&nbsp;<strong>bold</strong>&nbsp;&nbsp; and &nbsp;&nbsp;<em>italic</em>&nbsp;&nbsp; styles for your keywords.', 'CURLYTHEME').'</li>' : null; ?>
							<li><?php printf("Don't see meta keywords? We are in the great year of %s. Meta Keywords are deprecated since long time ago. <a href='http://en.wikipedia.org/wiki/Meta_element#The_keywords_attribute' target='_blank'>%s</a>", date('Y'), __('Check Wikipedia', 'CURLYTHEME')); ?>
							</li>
						</ul>
					</div>
				</div>
			</div>
		</div>
		<?php endif; ?>
		
		<?php if ( !curly_check_contact_page_template( $post->ID ) ) : ?>
		<div id="slider" class="<?php if ( isset( $slider ) ) { echo $slider; } ?>">
			<div id="slider-container">
				<?php 
				
				$object_slider = new CurlyMetaBoxOption( THEMEPREFIX.'_slider' , __('Choose Slider:', 'CURLYTHEME') , $slider , __('Choose your header slider', 'CURLYTHEME') , array( array( 'name' => __('No Slider', 'CURLYTHEME'), 'value' => 'no-slider' ), array( 'name' => __('Layer Slider', 'CURLYTHEME'), 'value' => 'layer-slider' ), array( 'name' => __('iOS Slider', 'CURLYTHEME'), 'value' => 'ios-slider' ), array( 'name' => __('Round About Slider', 'CURLYTHEME'), 'value' => 'roundabout-slider' ) ) ); 
				$object_slider->select(); 
				
				$options = array();
				
				global $wpdb;
				
				$options[0] = array( 'name' => __( 'Choose Layer Slider' , 'CURLYTHEME' ) , 'value' => null );
				
				$table_name = $wpdb->prefix . "layerslider";
				
				$layer_sliders = $wpdb->get_results( "SELECT * FROM $table_name WHERE flag_hidden = '0' AND flag_deleted = '0' ORDER BY date_c ASC" );
				
				foreach ($layer_sliders as $key => $slider) {
					array_push($options, array( 'name' => $slider->name , 'value' => $slider->id ));
				}
				
				$object_layer_slider = new CurlyMetaBoxOption( THEMEPREFIX.'_slider_shortcode' , __('Layer Slider:', 'CURLYTHEME') , $slider_shortcode , __('Choose your Layer Slider', 'CURLYTHEME') , $options, 'layer-slider-row' ); 
				$object_layer_slider->select();
				
				$object_slider_text_color = new CurlyMetaBoxOption( THEMEPREFIX.'_slider_text_color' , __('Slider Text Color:', 'CURLYTHEME') , $slider_text_color , __('Choose iOS Slider Text Color', 'CURLYTHEME') , null , 'ios-slider-row ' ); 
				$object_slider_text_color->color();
				
				$object_slider_bg_color = new CurlyMetaBoxOption( THEMEPREFIX.'_slider_color' , __('Slider Backgorund Color:', 'CURLYTHEME') , $slider_color , __('Choose iOS Slider Background Color', 'CURLYTHEME') , null , 'ios-slider-row ' ); 
				$object_slider_bg_color->color();
				
				$object_slider_push = new CurlyMetaBoxOption( THEMEPREFIX.'_slider_push' , __('Mobile Slider:', 'CURLYTHEME') , $slider_push , __('Check this to push the slider below the header on mobile devices', 'CURLYTHEME') , null , 'ios-slider-row layer-slider-row roundabout-slider-row' ); 
				$object_slider_push->checkbox();
	
				
				$elems = 0;
				
				if ( count( $slider_titles ) > $elems ) {
					$elems = count( $slider_titles );
				}
				
				if ( count( $slider_subtitles ) > $elems ) {
					$elems = count( $slider_subtitles );
				}
				
				if ( count( $slider_links ) > $elems ) {
					$elems = count( $slider_links );
				}
				
				if ( count( $slider_images ) > $elems ) {
					$elems = count( $slider_images );
				}
				
				if ( $elems > 0 ) : for ($i = 0; $i < $elems; $i++) :
				
				if ( is_numeric( $slider_images[$i] ) ) {
					$slider_images[$i] = wp_get_attachment_url( $slider_images[$i] );
				}
				
				?>
				
				<div class="form-control ios-slider-row roundabout-slider-row image-field slide">
		  			<label class="name"><?php _e( 'Slide' , 'CURLYTHEME' ); ?> #<?php echo $i + 1; ?></label>
		  			<div>
		  				<div class="ios-slider-child roundabout-slider-child">
		  				<label><?php _e( 'Slide Title:', 'CURLYTHEME' ) ?></label>
		  				<input type="text" class="text-field" name="<?php echo THEMEPREFIX ?>_slides_titles[]" value="<?php echo $slider_titles[$i] ?>">
		  				<span class="description"><?php _e('Set a title for your slide', 'CURLYTHEME'); ?></span>
		  				</div>
		  				<div class="ios-slider-child">
		  				<label><?php _e( 'Slide Subtitle:', 'CURLYTHEME' ) ?></label>
		  				<input type="text" class="text-field" name="<?php echo THEMEPREFIX ?>_slides_subtitles[]" value="<?php echo $slider_subtitles[$i] ?>">
		  				<span class="description"><?php _e('Set a subtitle for your slide', 'CURLYTHEME'); ?></span>
		  				</div>
		  				<div class="ios-slider-child roundabout-slider-child">
		  				<label><?php _e( 'Slide Link:', 'CURLYTHEME' ) ?></label>
		  				<input type="text" class="text-field" name="<?php echo THEMEPREFIX ?>_slides_links[]" value="<?php echo $slider_links[$i] ?>">
		  				<span class="description"><?php _e('Set a link for your slide', 'CURLYTHEME'); ?></span>
		  				</div>
		  				<div class="ios-slider-child roundabout-slider-child">
		  				<label><?php _e( 'Slide Image:', 'CURLYTHEME' ) ?></label>
		  				<input type="text" class="text-field" name="<?php echo THEMEPREFIX ?>_slides_images[]" value="<?php echo $slider_images[$i] ?>">
		  				<a href="#" class="image-upload-button button button-primary button-large" data-upload-title="<?php _e('Upload Slide Image', 'CURLYTHEME'); ?>" data-upload-button="<?php _e('Insert Image', 'CURLYTHEME'); ?>"><?php _e('Upload Slide Image', 'CURLYTHEME'); ?></a>
		  				<a href="#" class="image-clear-button button button-large" style="display:none"><?php _e('Clear Slide Image', 'CURLYTHEME'); ?></a>
		  				<?php if( isset( $slider_images[$i] ) && !empty( $slider_images[$i] ) ) :  ?>
		  				<img src="<?php echo $slider_images[$i]; ?>" class="image-preview" alt="" />
		  				<?php endif; ?>
		  				<span class="description"><?php _e('Choose the slide image', 'CURLYTHEME'); ?></span>
		  				</div>
		  			</div>
		  		</div>
		  		
		  		<?php endfor; endif; ?>
		  		
				<div class="form-control ios-slider-row roundabout-slider-row buttons">
					<label class="name">&nbsp;</label>
					<div>
						<a href="#" id="add_slide" class="button button-primary"><?php _e( 'Add New Slide' , 'CURLYTHEME' ); ?></a> &nbsp;
						<a href="#" id="delete_slide" class="button"><?php _e( 'Delete Slide' , 'CURLYTHEME' ); ?></a>
					</div>
				</div>
			</div>
		</div>
		<script type="text/javascript">
		(function($) {
		  	"use strict";
		  	
		  	function call_image_field() {
		  		$('.image-upload-button').click(function (e) {
		  			var el = $(this).parent();
		  			var button = $(this);
		  			e.preventDefault();
		  			var uploader = wp.media({
		  				title : button.data('upload-title'),
		  				button : {
		  					text : button.data('upload-button')
		  				},
		  				multiple : false
		  			})
		  			.on('select', function () {
		  				var selection = uploader.state().get('selection');
		  				var attachment = selection.first().toJSON();
		  				$('input[type=text]', el).val(attachment.url);
		  				$('input[type=hidden]', el).val(attachment.id);
		  				if (!el.hasClass('upload_file')) {
		  					if ($('img', el).length > 0) {
		  						$('.image-preview', el).attr('src', attachment.url);
		  					} else {
		  						$('<img src="'+ attachment.url +'" class="image-preview">').insertBefore($(':last-child', el));
		  						$('.image-clear-button', el).attr('style', 'display:inline-block');
		  					}
		  				}
		  			})
		  			.open();
		  		});
		  	}
		  	
		  	function add_slide( parent ) {
		  		$(this).parent(expr)
		  	}
		  	
		  	$("#<?php echo THEMEPREFIX ?>_slider").on('change', function (e) {
		  	
		  		var val = $(this).val();
		  		var container = $(this).parents('#slider');			
		  		
		  		switch (val) {
		  			case 'no-slider' : container.removeClass('layer-slider ios-slider roundabout-slider').addClass('no-slider'); break;
		  			case 'layer-slider' : container.removeClass('no-slider ios-slider roundabout-slider').addClass('layer-slider'); break;
					case 'ios-slider' : container.removeClass('no-slider layer-slider roundabout-slider').addClass('ios-slider'); break;	
					case 'roundabout-slider' : container.removeClass('no-slider layer-slider ios-slider').addClass('roundabout-slider'); break;	
		  		}
		  	});
		  	
		  	$('#add_slide').on('click', function (e) {
		  		
		  		// Prevent Default
		  		e.preventDefault();
		  		
		  		// New Row
		  		var newRow   =	'<div class="form-control ios-slider-row roundabout-slider-row image-field slide">' +
	  					  			'<label class="name"><?php _e( 'Slide' , 'CURLYTHEME' ); ?> #' + ( $('.slide').length + 1 ) + '</label>' +
	  					  			'<div>' +
	  					  				'<div class="ios-slider-child roundabout-slider-child">' +
	  					  				'<label><?php _e( 'Slide Title:', 'CURLYTHEME' ) ?></label>' +
	  					  				'<input type="text" class="text-field" name="<?php echo THEMEPREFIX ?>_slides_titles[]">' +
	  					  				'<span class="description"><?php _e('Set a Title for your slide', 'CURLYTHEME'); ?></span>' +
	  					  				'</div>' +
	  					  				'<div class="ios-slider-child">' +
	  					  				'<label><?php _e( 'Slide Subtitle:', 'CURLYTHEME' ) ?></label>' +
	  					  				'<input type="text" class="text-field" name="<?php echo THEMEPREFIX ?>_slides_subtitles[]">' +
	  					  				'<span class="description"><?php _e('Set a Subtitle for your slide', 'CURLYTHEME'); ?></span>' +
	  					  				'</div>' +
	  					  				'<div class="ios-slider-child roundabout-slider-child">' +
	  					  				'<label><?php _e( 'Slide Link:', 'CURLYTHEME' ) ?></label>' +
	  					  				'<input type="text" class="text-field" name="<?php echo THEMEPREFIX ?>_slides_links[]">' +
	  					  				'<span class="description"><?php _e('Set a Link for your slide', 'CURLYTHEME'); ?></span>' +
	  					  				'</div>' +
	  					  				'<div class="ios-slider-child roundabout-slider-child">' +
	  					  				'<label><?php _e( 'Slide Image:', 'CURLYTHEME' ) ?></label>' +
	  					  				'<input type="text" class="text-field" name="<?php echo THEMEPREFIX ?>_slides_images[]">' +
	  					  				'<a href="#" class="image-upload-button button button-primary button-large" data-upload-title="<?php _e('Upload Slide Image', 'CURLYTHEME'); ?>" data-upload-button="<?php _e('Insert Image', 'CURLYTHEME'); ?>"><?php _e('Upload Slide Image', 'CURLYTHEME'); ?></a>' +
	  					  				'<a href="#" class="image-clear-button button button-large" style="display:none"><?php _e('Clear Slide Image', 'CURLYTHEME'); ?></a>' +
	  					  				'<span class="description"><?php _e('Choose the slide image', 'CURLYTHEME'); ?></span>' +
	  					  				'</div>' +
	  					  			'</div>' +
	  					  		'</div>';
		  		
		  		var cont = $(this).parents('.form-control.buttons');
		  		
		  		$( newRow ).insertBefore( cont );
		  		
		  		call_image_field();
		  		
		  	});
		  	
		  	$('#delete_slide').on('click', function (e) {
		  		
		  		// Prevent Default
		  		e.preventDefault();
		  		
		  		var last = $(this).parents('.form-control.buttons').siblings('.slide').last();
		  		
		  		if ( confirm( "Are you sure you want to delete this slide?" ) ) {
		  			last.remove();
		  		}
		  		
		  	});
		  	
	  	})(jQuery); 
	  	</script>
	  	<?php endif; ?>
		
		
		<div id="bg">
			<div>
				<?php 
				
				$object_bg_color = new CurlyMetaBoxOption( THEMEPREFIX.'_bg_color' , __('Backgorund Color:', 'CURLYTHEME') , $bg_color , __('Choose the background color', 'CURLYTHEME') , null ); 
				$object_bg_color->color();
				
				$object_bg_image = new CurlyMetaBoxOption( THEMEPREFIX.'_bg_image' , __('Background Image:', 'CURLYTHEME') , array( $bg_img_id , $bg_img ) , __('Choose the background image', 'CURLYTHEME') , array( 'upload_title' => __('Upload Background Image', 'CURLYTHEME'), 'upload_button' => __('Insert Image', 'CURLYTHEME'), 'upload_link' => __('Upload Background', 'CURLYTHEME') , 'clear_link' => __('Clear Background', 'CURLYTHEME') ) ); 
				$object_bg_image->image();
				
				$object_bg_pos = new CurlyMetaBoxOption( THEMEPREFIX.'_bg_position' , __('Background Position:', 'CURLYTHEME') , $bg_pos , __('Choose the background image position', 'CURLYTHEME') , array( array( 'name' => __('Top Left', 'CURLYTHEME'), 'value' => 0 ), array( 'name' => __('Top Center', 'CURLYTHEME'), 'value' => 1 ), array( 'name' => __('Top Right', 'CURLYTHEME'), 'value' => 2 ), array( 'name' => __('Middle Left', 'CURLYTHEME'), 'value' => 3 ), array( 'name' => __('Middle Center', 'CURLYTHEME'), 'value' => 4 ), array( 'name' => __('Middle Right', 'CURLYTHEME'), 'value' => 5 ), array( 'name' => __('Bottom Left', 'CURLYTHEME'), 'value' => 6 ), array( 'name' => __('Bottom Center', 'CURLYTHEME'), 'value' => 7 ), array( 'name' => __('Bottom Right', 'CURLYTHEME'), 'value' => 8 ) ) ); 
				$object_bg_pos->select(); 
				
				$object_bg_repeat = new CurlyMetaBoxOption( THEMEPREFIX.'_bg_repeat' , __('Background Repeat:', 'CURLYTHEME') , $bg_rep , __('Choose the background image repeat method', 'CURLYTHEME') , array( array( 'name' => __('Repeat', 'CURLYTHEME'), 'value' => 0 ), array( 'name' => __('No Repeat', 'CURLYTHEME'), 'value' => 1 ), array( 'name' => __('Vertically', 'CURLYTHEME'), 'value' => 2 ), array( 'name' => __('Horizontally', 'CURLYTHEME'), 'value' => 3 ) ) ); 
				$object_bg_repeat->select(); 
				
				$object_bg_size = new CurlyMetaBoxOption( THEMEPREFIX.'_bg_size' , __('Background Size:', 'CURLYTHEME') , $bg_size , __('Choose the background image size', 'CURLYTHEME') , array( array( 'name' => __('Auto', 'CURLYTHEME'), 'value' => 0 ), array( 'name' => __('Cover', 'CURLYTHEME'), 'value' => 1 ), array( 'name' => __('Contain', 'CURLYTHEME'), 'value' => 2 ) ) ); 
				$object_bg_size->select(); 
				
				$object_bg_att = new CurlyMetaBoxOption( THEMEPREFIX.'_bg_attachment' , __('Background Attachment:', 'CURLYTHEME') , $bg_att , __('Choose the background image attachment method', 'CURLYTHEME') , array( array( 'name' => __('Scroll', 'CURLYTHEME'), 'value' => 0 ), array( 'name' => __('Fixed', 'CURLYTHEME'), 'value' => 1 ), array( 'name' => __('Local', 'CURLYTHEME'), 'value' => 2 ) ) ); 
				$object_bg_att->select(); 
				
				?>

			</div>
		</div><!-- end background -->
		
		<div id="header">
			<div>
				<?php 
				
				$object_header_top = new CurlyMetaBoxOption( THEMEPREFIX.'_header_margin_top' , __('Top Margin:', 'CURLYTHEME') , $header_top , sprintf( __('Choose the header top margin. Default is %d px', 'CURLYTHEME'), get_option( THEMEPREFIX . '_header_margin_top', 55 ) ) , array( 'step' => 1, 'min' => 0, 'max' => 300, 'suf' => 'px' ) ); 
				$object_header_top->slider(); 
				
				$object_header_bot = new CurlyMetaBoxOption( THEMEPREFIX.'_header_margin_bottom' , __('Bottom Margin:', 'CURLYTHEME') , $header_bot , sprintf( __('Choose the header bottom margin. Default is %d px', 'CURLYTHEME'), get_option( THEMEPREFIX . '_header_margin_bottom', 75 ) ) , array( 'step' => 1, 'min' => 0, 'max' => 300, 'suf' => 'px' ) ); 
				$object_header_bot->slider();
				
				$object_header_text = new CurlyMetaBoxOption( THEMEPREFIX.'_header_text' , __('Text Color:', 'CURLYTHEME') , $header_text , __('Choose the header text color', 'CURLYTHEME') , null ); 
				$object_header_text->color();
				
				$object_header_bg = new CurlyMetaBoxOption( THEMEPREFIX.'_header_bg_color' , __('Header Color:', 'CURLYTHEME') , $header_bg , __('Choose the header background color', 'CURLYTHEME') , null ); 
				$object_header_bg->color();
				
				$object_header_bg_opac = new CurlyMetaBoxOption( THEMEPREFIX.'_header_opacity' , __('Header Opacity Opacity:', 'CURLYTHEME') , $header_opac , sprintf( __('Choose the header background color opacity. Default is %d px', 'CURLYTHEME'), get_option( THEMEPREFIX . '_header_shading_opacity', 75 ) ) , array( 'step' => 0.1, 'min' => 0, 'max' => 100, 'suf' => '%' ) ); 
				$object_header_bg_opac->slider();
				
				$object_header_img = new CurlyMetaBoxOption( THEMEPREFIX.'_header_image' , __('Header Image:', 'CURLYTHEME') , array( $header_img_id , $header_img ) , __('Choose the header image', 'CURLYTHEME') , array( 'upload_title' => __('Upload Header Image', 'CURLYTHEME'), 'upload_button' => __('Insert Image', 'CURLYTHEME'), 'upload_link' => __('Upload Header Image', 'CURLYTHEME') , 'clear_link' => __('Clear Header Image', 'CURLYTHEME') ) ); 
				$object_header_img->image();
				
				$object_header_lg = new CurlyMetaBoxOption( THEMEPREFIX.'_header_image_large' , __('Use Large Header:', 'CURLYTHEME') , $header_lg , __('Use this image as a large header (Hide Title & Breadcrumbs)', 'CURLYTHEME') ); 
				$object_header_lg->checkbox();
				
				?>
			</div>
		</div><!-- end header -->
		
		<div id="page">
			<div>
				<?php 
				
				$object_heading_color = new CurlyMetaBoxOption( THEMEPREFIX.'_heading_color' , __('Page Heading Color:', 'CURLYTHEME') , $heading_color , __('Choose the page heading text color', 'CURLYTHEME') , null ); 
				$object_heading_color->color();
				
				$object_bc = new CurlyMetaBoxOption( THEMEPREFIX.'_breadcrumbs' , __('Hide Breadcrumbs:', 'CURLYTHEME') , $bc , __('Check this to this the breadcrumbs', 'CURLYTHEME') ); 
				$object_bc->checkbox();
				
				$object_heading = new CurlyMetaBoxOption( THEMEPREFIX.'_heading' , __('Hide Page Heading:', 'CURLYTHEME') , $heading , __('Check this to this the page heading (Hide Title & Breadcrumbs)', 'CURLYTHEME') ); 
				$object_heading->checkbox();
				
				$sidebars = array( array( 'name' => __( 'No Sidebar' , 'CURLYTHEME' ) , 'value' => null ) );
				
				global $wp_registered_sidebars; 
				
				foreach ( $wp_registered_sidebars as $value ) {
					array_push($sidebars, array( 'name' => $value['name'] , 'value' => $value['id'] ));
				}
				
				$object_sidebars = new CurlyMetaBoxOption( THEMEPREFIX.'_sidebar' , __('Custom Sidebar:', 'CURLYTHEME') , $sidebar , __('Choose your sidebar', 'CURLYTHEME') , $sidebars ); 
				$object_sidebars->select(); 
				
				?>
			</div>
		</div><!-- end page -->
		
    </div>
    <script type="text/javascript">
    (function($) {
      	"use strict";
      	
      	// Tabs
      	$(function() {
      	    $( "#individual-page-settings-wrapper" ).tabs();
      	});
      	
      	// SEO - Title Change
      	$('input[id$="_seo_title"]').on('input', function () {
      	
      		var field_count = $(this).val().length;
      		var field_text  = $(this).val();
      		
      		$(this).siblings('span').children('strong').text(field_count);
      		
      		if (field_count > 70) {
      			$(this).siblings('span').children('strong').addClass('red');
      		} else {
      			$(this).siblings('span').children('strong').removeClass('red');
      		}
      	});
      	
      	// SEO - Description Change
      	$('textarea[id$="_seo_description"]').on('input', function () {
      	
      		var field_count = $(this).val().length;
      		var field_text  = $(this).val();
      		
      		$(this).siblings('span').children('strong').text(field_count);
      		
      		if (field_count > 160) {
      			$(this).siblings('span').children('strong').addClass('red');
      		} else {
      			$(this).siblings('span').children('strong').removeClass('red');
      		}
      	});
      	
      	// Clear Buttons
      	$('.image-clear-button').click( function (e) {
      		$(this).siblings('input[type=text]').val(null);
      		$(this).siblings('input[type=hidden]').val(null);
      		$(this).siblings('.image-preview').remove();
      		
      		e.preventDefault();
      	});
      	
      	// Document Ready
      	$(document).ready( function() {
      	
      		// Color Picker	
      		$('.color-picker').wpColorPicker();
      		
      		// Panels Height
      		var list_height = 100;
      		$('#individual-page-settings-wrapper > ul > li[role*=tab]').each(function () {
      			list_height += $(this).outerHeight();
      		});
      		
      		$('#individual-page-settings-wrapper div.ui-tabs-panel').each(function () {
      			var existing_style = $(this).attr('style');
      			var new_style = ( existing_style ) ? (existing_style + ' min-height: ' + list_height + 'px;') : 'min-height: ' + list_height + 'px;';
      			$(this).attr('style', new_style);
      		});
      		
      		// Image Field
      		call_image_field();
      		
      		function call_image_field() {
	      		// Function Upload Media
	      		$('.image-upload-button').click(function (e) {
	      			var el = $(this).parent();
	      			var button = $(this);
	      			e.preventDefault();
	      			var uploader = wp.media({
	      				title : button.data('upload-title'),
	      				button : {
	      					text : button.data('upload-button')
	      				},
	      				multiple : false
	      			})
	      			.on('select', function () {
	      				var selection = uploader.state().get('selection');
	      				var attachment = selection.first().toJSON();
	      				$('input[type=text]', el).val(attachment.url);
	      				$('input[type=hidden]', el).val(attachment.id);
	      				if (!el.hasClass('upload_file')) {
	      					if ($('img', el).length > 0) {
	      						$('.image-preview', el).attr('src', attachment.url);
	      					} else {
	      						$('<img src="'+ attachment.url +'" class="image-preview">').insertBefore($(':last-child', el));
	      						$('.image-clear-button', el).attr('style', 'display:inline-block');
	      					}
	      				}
	      			})
	      			.open();
	      		});
      		}
      		
      	});
      	
    })(jQuery); 
    </script>
	<?php	
}

// Save Meta Data
add_action( 'save_post', 'curly_save_individual_page_settings', 10, 2 );
function curly_save_individual_page_settings( $post_id, $post )
{
	// Bail if we're doing an auto save
	if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
	
	// if our nonce isn't there, or we can't verify it, bail
	if( !isset( $_POST['meta_box_nonce'] ) || !wp_verify_nonce( $_POST['meta_box_nonce'], 'my_meta_box_nonce' ) ) return;
	
	/* Get the post type object. */
	$post_type = get_post_type_object( $post->post_type );
	
	/* Check if the current user has permission to edit the post. */
	if ( !current_user_can( $post_type->cap->edit_post, $post_id ) )
		return $post_id;
	
	$values = array(
		THEMEPREFIX.'_seo_title',
		THEMEPREFIX.'_seo_description',
		THEMEPREFIX.'_bg_color',
		THEMEPREFIX.'_bg_image', 
		THEMEPREFIX.'_bg_image_id', 
		THEMEPREFIX.'_bg_position',
		THEMEPREFIX.'_bg_repeat',
		THEMEPREFIX.'_bg_size',
		THEMEPREFIX.'_bg_attachment',
		THEMEPREFIX.'_header_text',
		THEMEPREFIX.'_header_bg_color',
		THEMEPREFIX.'_header_opacity',
		THEMEPREFIX.'_header_image',
		THEMEPREFIX.'_header_image_id',
		THEMEPREFIX.'_header_image_large',
		THEMEPREFIX.'_header_margin_top',
		THEMEPREFIX.'_header_margin_bottom',
		THEMEPREFIX.'_heading_color',
		THEMEPREFIX.'_breadcrumbs',
		THEMEPREFIX.'_heading',
		THEMEPREFIX.'_slider_push',
		THEMEPREFIX.'_contact_side',
		THEMEPREFIX.'_latitude',
		THEMEPREFIX.'_longitude',
		THEMEPREFIX.'_map_type',
		THEMEPREFIX.'_map_height',
		THEMEPREFIX.'_map_color',
		THEMEPREFIX.'_map_marker',
		THEMEPREFIX.'_map_zoom',
		THEMEPREFIX.'_slider',
		THEMEPREFIX.'_slider_shortcode',
		THEMEPREFIX.'_slider_text_color',
		THEMEPREFIX.'_slider_color',
		THEMEPREFIX.'_slides_titles',
		THEMEPREFIX.'_slides_subtitles',
		THEMEPREFIX.'_slides_links',
		THEMEPREFIX.'_slides_images',
		THEMEPREFIX.'_sidebar'
	);
	
	// Update Post Meta or Delete Empty Post Meta
	foreach ( $values as $value) {
		if( isset( $_POST[$value] ) ) {
				
			if ( $value == THEMEPREFIX.'_header_margin_top' ) {
				if ( $_POST[$value] != get_option(THEMEPREFIX.'_header_margin_top') ) {
					update_post_meta( $post_id, $value, wp_kses_post( $_POST[$value] ) );
				} else {
					delete_post_meta( $post_id, $value );
				}
			} elseif ( $value == THEMEPREFIX.'_header_margin_bottom' ) {
				if ( $_POST[$value] != get_option(THEMEPREFIX.'_header_margin_bottom') ) {
					update_post_meta( $post_id, $value, wp_kses_post( $_POST[$value] ) );
				} else {
					delete_post_meta( $post_id, $value );
				}
			} elseif ( $value == THEMEPREFIX.'_header_opacity' ) {
				if ( $_POST[$value] != get_option(THEMEPREFIX.'_header_shading_opacity', 55) ) {
					update_post_meta( $post_id, $value, wp_kses_post( $_POST[$value] ) );
				} else {
					delete_post_meta( $post_id, $value );
				}
			} elseif ( $value == THEMEPREFIX.'_contact_side' ) {
				update_post_meta( $post_id, $value, wp_kses_post( $_POST[$value] ) );
			} else {
				update_post_meta( $post_id, $value, wp_kses( $_POST[$value] , null ) );
			}
				
		} else {
			delete_post_meta( $post_id, $value );
		}
	}
	
	$delete_values = array(
		THEMEPREFIX.'page_settings_heading_image',
		THEMEPREFIX.'page_settings_heading_image_id',
		'height',
		THEMEPREFIX.'map_color',
		THEMEPREFIX.'map_marker',
		THEMEPREFIX.'map_zoom',
		THEMEPREFIX.'map_height',
		THEMEPREFIX.'map_type',
		THEMEPREFIX.'longitude',
		THEMEPREFIX.'latitude',
		THEMEPREFIX.'contact_side',
		THEMEPREFIX.'header_push',
		THEMEPREFIX.'page_heading',
		'seodescription',
		'seotitle',
		'slider',
		'slider_shortcode',
		'slider_text_color',
		'slider_color',
		'slides_title',
		'slides_subtitle',
		'slides_link',
		'slides_images'
	);
	foreach ( $delete_values as $value) {
		if ( get_post_meta( $post_id, $value ) ) {
			delete_post_meta( $post_id, $value );
		}
	}
}
?>