<?php 

add_theme_support( 'woocommerce' );

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

	/* Register WooCommerce Sidebar */
    if ( function_exists('register_sidebar'))
    	register_sidebar(array(
    	'name'			 => 'Sidebar - Shop',
    	'id'			 => 'sidebar_shop',
    	'before_widget'	 => '<div id="%1$s" class="sidebar_widget %2$s">',
    	'after_widget' 	 => '</div>',
    	'before_title'	 => '<h5 class="special-title"><span>',
    	'after_title'	 => '</span></h5>',
    ));
    
    // Breadcrumbs 
    remove_action( 'woocommerce_before_main_content','woocommerce_breadcrumb', 20, 0);
    
    function curly_woocommerce_breadcrumbs() {
    	$before = (get_option(THEMEPREFIX.'_bc_text_before')) ? '<li>'.get_option(THEMEPREFIX.'_bc_text_before').'</li>' : null;
        return array(
                'delimiter'   => get_option(THEMEPREFIX.'_bc_separator', '&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;'),
                'wrap_before' => '<ul class="theme-bc" itemprop="breadcrumb">'.$before,
                'wrap_after'  => '</ul>',
                'before'      => '<li>',
                'after'       => '</li>',
                'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
            );
    }
    
    add_filter( 'woocommerce_breadcrumb_defaults', 'curly_woocommerce_breadcrumbs' );
    
    // Pagination 
	remove_action('woocommerce_pagination', 'woocommerce_pagination', 10);
	function woocommerce_pagination() {
		global $curly;
	    echo $curly->get_pagination();     
	}
	add_action( 'woocommerce_pagination', 'woocommerce_pagination', 10);
}

?>