<?php 

/*	Comments
	================================================= */
	function comments( $comment, $args, $depth ) {
		$GLOBALS['comment'] = $comment;
		switch ( $comment->comment_type ) :
			case 'pingback' :
			case 'trackback' :
		?>
		<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
			<p><?php _e( 'Pingback:', 'CURLYTHEME' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( __( '(Edit)', 'CURLYTHEME'), '<span class="edit-link">', '</span>' ); ?></p>
		<?php
				break;
			default :
			// Proceed with normal comments.
			global $post;
		?>
		<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">
			<article id="comment-<?php comment_ID(); ?>" class="comment">
				<header class="comment-meta comment-author vcard">
					<?php
						echo get_avatar( $comment, 40 );
						printf( '<cite class="fn">%1$s </cite>',
								get_comment_author_link()
						);
						printf( '<time datetime="%1$s">@ %2$s</time>',
								get_comment_time( 'c' ),
								sprintf( __( '%1$s at %2$s', 'CURLYTHEME' ), get_comment_date(), get_comment_time() )
						);
					?>
				</header><!-- .comment-meta -->
	
				<section class="comment-content comment">
					<div>
						<?php comment_text(); ?>
					</div>
					<?php comment_reply_link( array_merge( $args, array( 'reply_text' => __( 'Reply <i class="fa fa-share-alt"></i>', 'CURLYTHEME' ), 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?>
					<?php edit_comment_link( __( 'Edit', 'CURLYTHEME' ), '<span class="edit-link">', '</span>' ); ?>
					<?php if ( '0' == $comment->comment_approved ) : ?>
						<span class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'CURLYTHEME' ); ?></span>
					<?php endif; ?>
				</section>
			</article>
		<?php
			break;
		endswitch; 
	}

/*	Threaded Comments
	================================================= */
	function curly_xtreme_enqueue_comments_reply() {
	    if( get_option( 'thread_comments' ) )  {
	        wp_enqueue_script( 'comment-reply' );
	    }
	}
	add_action( 'comment_form_before', 'curly_xtreme_enqueue_comments_reply' );

/*	Hide Comments
	================================================= */
	if (get_option(THEMEPREFIX.'_general_comments_pages') == "true") {
		add_filter( 'comments_open', 'curly_comments_open', 10, 2 );
		
		function curly_comments_open( $open, $post_id ) {
			$post = get_post( $post_id );
			
				if ( 'page' == $post->post_type )
					$open = false;
			
				return $open;
		}	
	}

/*	Curly Comments
	================================================= */
	function curly_comments() {
	
		global $post;
		
		if ( comments_open() && get_option(THEMEPREFIX.'_fb_comments') != "true" ) {
			comments_template();
		} elseif ( comments_open() ) {
			echo '<div id="fb-root"></div>';
			echo '<script>(function(d, s, id) {
			  var js, fjs = d.getElementsByTagName(s)[0];
			  if (d.getElementById(id)) return;
			  js = d.createElement(s); js.id = id;
			  js.src = "//connect.facebook.net/en_US/all.js#xfbml=1&appId=233653370014075";
			  fjs.parentNode.insertBefore(js, fjs);
			}(document, "script", "facebook-jssdk"));</script>';
			
			echo '<h3>'.__('Comments' , 'CURLYTHEME').'</h3>';
			echo '<div class="fb-comments" data-href="'.get_permalink().'" data-width="470" data-num-posts="10"></div>';
		}
		
	}

?>