<?php 

	function calcDensity( $text ){  
	 
		// -------------------------------------------------------------------
		// Prepare string
		// -------------------------------------------------------------------
		$text = strtolower($text);
		$text = str_replace(',', '', $text);
		$text = str_replace('.', '', $text);
		$text = str_replace(';', '', $text);
		$text = str_replace('!', '', $text);
		$text = str_replace('?', '', $text);
		$words = explode(" ",$text);   
		$common_words = "i,he,she,it,and,me,my,you,the"; 
		$common_words = strtolower($common_words);
		$common_words = explode(",", $common_words);
		
		// -------------------------------------------------------------------
		// Get keywords
		// -------------------------------------------------------------------      
		$words_sum = 0;     
		foreach ($words as $value){
			$common = false;
			$value = trim_replace($value);
			if (strlen($value) > 3){
				foreach ($common_words as $common_word){
					if ($common_word == $value){
					$common = true;
					}
				}
				if ($common != true){
					if (!preg_match("/http/i", $value) && !preg_match("/mailto:/i", $value)) {
						$keywords[] = $value;
						$words_sum++;
					}
				}
			}
		}  
		  
		// -------------------------------------------------------------------
		// Do some maths and write array
		// ------------------------------------------------------------------- 
		$keywords = array_count_values($keywords);
		arsort($keywords);
		$results = array();
		$results []= array(
			'total words' => $words_sum
		);
		
		foreach ($keywords as $key => $value){
			$percent = 100 / $words_sum * $value;
			$results []= array(
				'keyword' => trim($key),
				'count' => $value,
				'percent' => round($percent, 2)
			);
		}
		
		// -------------------------------------------------------------------
		// Return array
		// -------------------------------------------------------------------
		return $results; 
	}
	    
	function trim_replace($string) {
		$string = trim($string);
		return (string)str_replace(array("\r", "\r\n", "\n"), '', $string);
	}
?>
