<?php 

class CurlyThemesSlider {

	private $_slider;
	private $_slider_text_color;
	private $_slider_color;
	private $_shortcode;
	private $_links;
	private $_images;
	private $_titles;
	private $_subtitles;
	
	public function __construct() {
		
		global $post;
		$post_id = $post->ID;
	
		$slider 			= new CurlyGetValue( 'meta', THEMEPREFIX.'_slider', null, 'slider', $post_id );
		$slider_text_color 	= new CurlyGetValue( 'meta', THEMEPREFIX.'_slider_text_color', null, 'slider_text_color', $post_id );
		$slider_color 		= new CurlyGetValue( 'meta', THEMEPREFIX.'_slider_color', null, 'slider_color', $post_id );
		$slider_shortcode 	= new CurlyGetValue( 'meta', THEMEPREFIX.'_slider_shortcode', null, 'slider_shortcode', $post_id );
		$links 				= new CurlyGetValue( 'meta', THEMEPREFIX.'_slides_links', null, 'slides_link', $post_id );
		$images 			= new CurlyGetValue( 'meta', THEMEPREFIX.'_slides_images', null, 'slides_images', $post_id );
		$titles 			= new CurlyGetValue( 'meta', THEMEPREFIX.'_slides_titles', null, 'slides_title', $post_id );
		$subtitles 			= new CurlyGetValue( 'meta', THEMEPREFIX.'_slides_subtitles', null, 'slides_subtitle', $post_id );
		
		$this->_slider 				= $slider->result();
		$this->_slider_text_color 	= $slider_text_color->result();
		$this->_slider_color 		= $slider_color->result();
		$this->_shortcode 			= $slider_shortcode->result();
		$this->_links 				= $links->result();
		$this->_images 				= $images->result();
		$this->_titles 				= $titles->result();
		$this->_subtitles 			= $subtitles->result();
		
		if ( strlen($this->_shortcode) >= 5 ) {
			preg_match('/id=\"(\d+)\"/', $this->_shortcode, $matches);
			if ( $matches ) {
				$this->_shortcode = $matches[1];
			}
		}
	}
	
	public function __toString() {
		echo do_shortcode( $this->slider() );
	}
	
	function slider() {
		
		if( $this->_slider != 'no-slider' ){
				
				// iOS Slider
				if( $this->_slider == 'ios-slider' ){
				
					if ( !empty( $this->_images ) ) {
						
						$settings = null;
						
						if( $this->_slider_text_color != "#" ) $settings .= ' textcolor="'.$this->_slider_text_color.'"';
						if( $this->_slider_text_color != "#" ) $settings .= ' bgcolor="'.$this->_slider_color.'"';
			
						$out = '[ios-slider'.$settings.']';
						
						for( $i=0; $i<count($this->_links); $i++ ) {
							$img = wp_get_attachment_image_src($this->_images[$i], 'full');
							$out .= '[ios-slide title="'.$this->_titles[$i].'" subtitle="'.$this->_subtitles[$i].'"  link="'.$this->_links[$i].'"  textcolor="'.$this->_slider_text_color.'" bgcolor="'.$this->_slider_color.'" image="'.( ( is_numeric($this->_images[$i]) ) ? $img[0] : $this->_images[$i] ).'"][/ios-slide]';
						}
						$out .= '[/ios-slider]';
						
						echo do_shortcode( $out );
					}
				}
				
				// Round About Slider
				elseif( $this->_slider == 'roundabout-slider'){
					
					$settings = null;
					
					if( $this->_slider_text_color != "#" ) $settings .= ' textcolor="'.$this->_slider_text_color.'"';
					if( $this->_slider_text_color != "#" ) $settings .= ' bgcolor="'.$this->_slider_color.'"';
					
					$out = '[roundabout-slider'.$settings.']';
					
					foreach ($this->_images as $key => $value) {
						$img = wp_get_attachment_image_src($this->_images[$key], 'full');
						$out .= '[roundabout-slide image="'.( ( is_numeric($this->_images[$key]) ) ? $img[0] : $this->_images[$key] ).'"  title="'.$this->_titles[$key].'" link="'.$this->_links[$key].'"][/roundabout-slide]';
					}
					
					$out .= '[/roundabout-slider]';
		
					echo do_shortcode( $out );
				}
				
				// Layer Slider
				elseif( $this->_slider == 'layer-slider' && !is_null($this->_shortcode) ){
					$out = '[layerslider id="'.$this->_shortcode.'"]';
					
					echo do_shortcode( $out );
				}
			}
	}
	
}
?>