<?php 

class CurlyGetValue {
	
	private $_type;
	private $_key;
	private $_default;
	private $_old;
	private $_post_id;
	private $_result;
	
	public function __construct( $type, $key, $default = null, $old = null, $post_id = null ) {
		
		$this->_key = $key;
		
		if ( $default ) {
			$this->_default = $default;
		}
		
		if ( $old ) {
			$this->_old = $old;
		}
		
		if ( $post_id ) {
			$this->_post_id = $post_id;
		}
		
		switch ( $type ) {
			case 'option' : {
				$this->_result = $this->option(); 
			} break;
			
			case 'meta' : {
				$this->_result = $this->meta();
			} break;
			
			default : {
				$this->_result = null;
			}
		}
	}
	
	public function result() {
		return ( $this->_result ) ? $this->_result : null ;
	}
	
	public function __toString() {
		return $this->_result;
	}
	
	private function option(){
	
		$result =  get_option( $this->_key, $this->_default );
		
		if ( empty( $result ) ) {
			$result =  get_option( $this->_old );
		}
		
		return $result;
	}
	
	private function meta() {
	
		$result = get_post_meta( $this->_post_id, $this->_key, true );
		
		if ( empty( $result ) ) {
			$result = get_post_meta( $this->_post_id, $this->_old, true );
		}
		
		return $result;
	}
	
}

?>