<?php 

class CurlyThemesFont {

	public $_family;
	public $_size;
	public $_style;
	public $_variant;
	
	public function __construct( $family = null, $size = null, $style = null, $variant = null ) {
		$this->_family 	= $this->get_font_family( $family );
		$this->_size 	= $size;
		$this->_style 	= $this->get_font_style( $style );
		$this->_variant = $this->get_font_variant( $variant );
	}
	
	private function get_font_family( $family ) {
	
		$json_fonts_data = json_decode( get_option( THEMEPREFIX.'_json_font_list' ), true );
		
		return $json_fonts_data[$family][1];
	}
	
	private function get_font_style( $style ){
		switch ( $style ) {
			case 0 : return 'font-weight: 300;';break;
			case 1 : return 'font-weight: 300;font-style: italic;';break;
			case 2 : return 'font-weight: normal;font-style: normal;';break;
			case 3 : return 'font-weight: 700;'; break;
			case 4 : return 'font-style: italic;';break;
			case 5 : return 'font-style: italic; font-weight: bold;';break;
		}
	}

	private function get_font_variant( $variant ){
		switch ( $variant ) {
			case 0 : return 'text-transform: none;';break;
			case 1 : return 'text-transform: capitalize;';break;
			case 2 : return 'text-transform: uppercase;';break;
			case 3 : return 'font-variant: small-caps;';break;
		}
	}
	
}

class CurlyThemesLoadFonts {
	
	private $_font_data;
	
	public function __construct() {
		
		$this->_font_data = json_decode(get_option(THEMEPREFIX.'_json_font_list'), true);
	
		add_action('wp_footer', array($this, 'generate_font_list'));
		
	}
	
	public function generate_font_list() {
		
		$fonts = array();
		$fonts_list = array();
		
		array_push($fonts, array(get_option(THEMEPREFIX.'_fonts_body', 0), get_option(THEMEPREFIX.'_fonts_body_style', 0)));
		array_push($fonts, array(get_option(THEMEPREFIX.'_fonts_h1', 0), get_option(THEMEPREFIX.'_fonts_h1_style', 3)));
		array_push($fonts, array(get_option(THEMEPREFIX.'_fonts_h2', 3), get_option(THEMEPREFIX.'_fonts_h2_style', 0)));
		array_push($fonts, array(get_option(THEMEPREFIX.'_fonts_h3', 0), get_option(THEMEPREFIX.'_fonts_h3_style', 3)));
		array_push($fonts, array(get_option(THEMEPREFIX.'_fonts_h4', 2), get_option(THEMEPREFIX.'_fonts_h4_style', 2)));
		array_push($fonts, array(get_option(THEMEPREFIX.'_fonts_h5', 0), get_option(THEMEPREFIX.'_fonts_h5_style', 3)));
		array_push($fonts, array(get_option(THEMEPREFIX.'_fonts_h6', 0), get_option(THEMEPREFIX.'_fonts_h6_style', 3)));
		array_push($fonts, array(get_option(THEMEPREFIX.'_fonts_menu', 0), get_option(THEMEPREFIX.'_fonts_menu_style', 3)));
		array_push($fonts, array(get_option(THEMEPREFIX.'_fonts_blockquote', 0), get_option(THEMEPREFIX.'_fonts_blockquote_style', 4)));
		
		
		foreach ($fonts as $key => $value) {	
			if ( !in_array($value[0], $fonts_list) ) {
				$fonts_list[$value[0]][] = $this->font_weight($value[1]);
			}
		}
		
		foreach ($fonts_list as $key => $value) {
			if ( $this->_font_data[$key][0] == 0 ) {
				unset($fonts_list[$key]);
			} else {
				$fonts_list[$key] = implode(",", array_unique($value));
			}
		}
		
		if (count($fonts_list) > 0) {
			$html =  " <script type=\"text/javascript\">\n
						WebFontConfig = {
					    google: { families: [";
					    
		    foreach ($fonts_list as $key => $value) {
		    	
		    	$html .= "'".str_replace(' ', '+' ,$this->get_font_family($key)).":300,400,700".":".$this->get_font_subset()."', ";
		    	
		    }
					    	 			    
			$html .= " ] }
					  };
					  (function() {
					    var wf = document.createElement('script');
					    wf.src = ('https:' == document.location.protocol ? 'https' : 'http') +
					      '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
					    wf.type = 'text/javascript';
					    wf.async = 'true';
					    var s = document.getElementsByTagName('script')[0];
					    s.parentNode.insertBefore(wf, s);
					})(); </script>";
			
			echo $html;
		}
	}
	
	private function font_weight( $style ) {
		switch ( $style ) {
			case 0 : return 300; break;
			case 1 : return 300; break;
			case 2 : return 400; break;
			case 3 : return 700; break;
			case 4 : return 400; break;
			case 5 : return 700; break;
		}
	}
	
	private function get_font_subset() {
		switch ( get_option( THEMEPREFIX.'_fonts_subset', 0 ) ){
			case 0 	: return 'latin'; break;
			case 1 	: return 'latin,cyrillic-ext,cyrillic'; break;
			case 2 	: return 'latin,greek-ext,greek'; break;
			case 3 	: return 'latin,greek'; break;
			case 4 	: return 'latin,vietnamese'; break;
			case 5 	: return 'latin,latin-ext'; break;
			case 5 	: return 'latin,cyrillic'; break;
		}
	}
	
	private function get_font_family( $family ) {
		return $this->_font_data[$family][1];	
	}
}

if ( !is_admin() ) {
	new CurlyThemesLoadFonts();
}

?>