<?php 

class CurlyThemes {
	
	public function __construct() {
	
		// Google Analytics
		add_action('wp_footer', array($this, 'google_analytics'), 1);
		
		// Custom Footer Code
		add_action('wp_footer', array($this, 'custom_footer_code'), 9999999);
		
		// Category Sanitization
		add_filter( 'wp_list_categories', array($this, 'remove_category_list_rel') );
		add_filter( 'the_category', array($this, 'remove_category_list_rel') );	
		
		// Limit Excerpt
		add_filter( 'excerpt_length', array($this, 'excerpt_length'), 999 );
		
		// Add File Types
		add_filter('upload_mimes', array($this, 'custom_mime_types'));
		
		// HTML5 Shim
		add_action('wp_head', array($this, 'add_ie_html5_shim'));
		
		// Fix XUA
		add_action('send_headers', array($this, 'fix_xua'));
		
		// Responsive
		add_action('wp_head', array($this, 'responsive'), 1);
		
		// Google Verification
		add_action('wp_head', array($this, 'google_verification'), 2);
		
		// Google Publisher
		add_action('wp_head', array($this, 'google_publisher'), 3);
		
		// Meta Description
		add_action('wp_head', array($this, 'meta_description'), 4);
		
		// Favicons
		add_action('wp_head', array($this, 'favicons'), 5);
		
		// Generator
		add_action('wp_head', array($this, 'meta_generator'), 6);
		
		// Custom Head Code
		add_action('wp_head', array($this, 'custom_head_code'), 999999);
		
		// Page Title Filter
		if( get_option(THEMEPREFIX.'_seo') != "true" && get_option(THEMEPREFIX.'_seo_title_rewrite') != 'true') { 
			add_filter( 'wp_title', array($this, 'get_page_title'), 10, 2 );
		}
	}
	
/*	Google Analytics
	================================================= */
	function google_analytics() {
		if( get_option( THEMEPREFIX.'_seo_analytics' ) ) {
			echo "<script type=\"text/javascript\">
				var _gaq = _gaq || [];
				_gaq.push(['_setAccount', '".get_option( THEMEPREFIX.'_seo_analytics' )."']);
				_gaq.push(['_trackPageview']);
				
				(function() {
				  var ga = document.createElement('script'); ga.type = 'text/javascript'; ga.async = true;
				  ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') + '.google-analytics.com/ga.js';
				  var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(ga, s);
				})();
				</script>"; 
		}
	}

/*	Custom Footer Code
	================================================= */
	function custom_footer_code() {
		echo htmlspecialchars_decode( get_option(THEMEPREFIX.'_custom_body') );
	}

/*	Remove rel Attribute
	================================================= */	
	function remove_category_list_rel( $output ) {
	    return str_replace( ' rel="category tag"', '', $output );
	}

/*	Limit Excerpt
	================================================= */	
	function excerpt_length() {
		$length	= get_option(THEMEPREFIX.'_blog_listing_excerpt');
		if ( !$length ) $length = 60;
		return $length;
	}

/*	Add File Types
	================================================= */	
	function custom_mime_types($mimes)
	{
		$mimes['ttf'] = 'font/ttf';
		$mimes['woff'] = 'font/woff';
		$mimes['svg'] = 'font/svg';
		$mimes['eot'] = 'font/eot';
	
		return $mimes;
	}

/*	HTML5 Shim
	================================================= */	
	function add_ie_html5_shim () {
	    echo '<!--[if lt IE 9]>';
	    echo '<script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>';
	    echo '<script src="'.get_template_directory_uri() .'/js/respond.min.js"></script>';
	    echo '<![endif]-->';
	}

/*	Fix XUA
	================================================= */		
	function fix_xua(){
		if (isset($_SERVER['HTTP_USER_AGENT']) && (strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false)) header('X-UA-Compatible: IE=edge,chrome=1');
	}
	
/*	Responsive
	================================================= */
	function responsive() {
		if( get_option(THEMEPREFIX.'_general_responsive', 'true') == 'true' ){
			echo '<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0">';
		}
	}
	
/*	Google Verification
	================================================= */	
	function google_verification() {
		$verification = get_option(THEMEPREFIX.'_seo_webmaster'); 
		if( $verification ) {
			echo '<meta name="google-site-verification" content="'.$verification.'">';
		}
	}

/*	Google Publisher
	================================================= */	
	function google_publisher() {
		$pub = get_option(THEMEPREFIX.'_seo_publisher'); 
		if($pub) {
			echo '<link rel="publisher" href="'.$pub.'">';
		}
	}

/*	Meta Description
	================================================= */		
	function meta_description() {
		if ( is_page() || is_single() ) {
			global $post;
			$desc = get_post_meta($post->ID, THEMEPREFIX . "_seo_description", true);
			if ( empty( $desc ) ) {
				$desc = get_post_meta($post->ID, "seodescription", true); 
			}
			if ( get_option(THEMEPREFIX.'_seo') != "true" && $desc ) {
				echo '<meta name="description" content="'.$desc.'">';
			}
		}
	}

/*	Meta Generator
	================================================= */	
	function meta_generator() {
		echo '<meta name="generator" content="'.wp_get_theme()->get( 'Name' ) . " " . wp_get_theme()->get( 'Version' ).'">';
	}

/*	Favicon
	================================================= */	
	function favicons() {
		// General Favicon
		$favicon = get_option(THEMEPREFIX.'_general_favicon'); 
		if( $favicon ){
			echo '<link rel="icon" type="image/png" href="'.$favicon.'">';
		}
		
		// iPhone Icon
		$iphone_favicon = get_option(THEMEPREFIX.'_general_iphone_favicon'); 
		if( $iphone_favicon ){
			echo '<link rel="apple-touch-icon" href="'.$iphone_favicon.'">';
		}
		
		// Retina iPhone Icon
		$iphone_favicon_retina = get_option(THEMEPREFIX.'_general_iphone_favicon_retina'); 
		if($iphone_favicon_retina) {
			echo '<link rel="apple-touch-icon" sizes="114x114" href="'.$iphone_favicon_retina.'">';
		}
		
		// iPad Icon
		$ipad_favicon = get_option(THEMEPREFIX.'_general_ipad_favicon'); 
		if($ipad_favicon) {
			echo '<link rel="apple-touch-icon" sizes="72x72" href="'.$ipad_favicon.'">';
		}
		
		// Retina iPad Icon
		$ipad_favicon_retina = get_option(THEMEPREFIX.'_general_ipad_favicon_retina'); 
		if($ipad_favicon_retina) {
			echo '<link rel="apple-touch-icon" sizes="144x144" href="'.$ipad_favicon_retina.'">';
		}
	}

/*	Custom Head Code
	================================================= */		
	function custom_head_code() {
		echo htmlspecialchars_decode( get_option(THEMEPREFIX.'_custom_head') );
	}

/*	Breadcrumbs
	================================================= */	
	public function breadcrumbs() {
		
		global $post;
		
		$active					=		get_option(THEMEPREFIX.'_bc', true);
		$strings_before			=		get_option(THEMEPREFIX.'_bc_text_before');
		$strings_home			=		get_option(THEMEPREFIX.'_bc_text_home', get_option('blogname'));
		$strings_category		=		get_option(THEMEPREFIX.'_bc_text_category', __("Archive by Category '%s'" , 'CURLYTHEME'));
		$strings_search			=		get_option(THEMEPREFIX.'_bc_text_search', __("Search Results for '%s'" , 'CURLYTHEME'));
		$strings_tag			=		get_option(THEMEPREFIX.'_bc_text_tag', __("Posts Tagged '%s'" , 'CURLYTHEME'));
		$strings_author			=		get_option(THEMEPREFIX.'_bc_text_author', __("Articles Posted by '%s'" , 'CURLYTHEME'));
		$strings_404			=		get_option(THEMEPREFIX.'_bc_text_404', __("Page not found" , 'CURLYTHEME'));
		$strings_separator		=		get_option(THEMEPREFIX.'_bc_separator', '&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;');
		if (is_single() || is_page()) {
			$bc_page		 		= 		get_post_meta( $post->ID, THEMEPREFIX . '_breadcrumbs' , true );
		}
		
		if ( isset( $bc_page ) && !empty( $bc_page ) ) {
			$active = false;
		}
		
		if ($strings_before) $strings_before = '<li class="bc-before">'.$strings_before.'</li>';
		
		$home			 = home_url();
		$wrap_before	 = '<li>';
		$wrap_after 	 = '</li>';
		$link 			 = $wrap_before . '<a href="%1$s">%2$s</a>' . $strings_separator. $wrap_after;
		$html 			 = '<ul class="theme-bc">'.$strings_before. sprintf($link, $home, $strings_home);
		
		if ( is_page() && !$post->post_parent ) {
			$html .= $wrap_before.get_the_title().$wrap_after;
	
		} elseif ( is_page() && $post->post_parent ) {
			$parent_id  = $post->post_parent;
			$bc = array();
			while ($parent_id) {
				$page = get_page($parent_id);
				$bc[] = sprintf($link, get_permalink($page->ID), get_the_title($page->ID));
				$parent_id  = $page->post_parent;
			}
			$bc = array_reverse($bc);
			for ($i = 0; $i < count($bc); $i++) {
				$html .= $bc[$i];
			}
			$html .= $wrap_before.get_the_title().$wrap_after;
	
		} elseif (is_home()){
			$html .= $wrap_before.get_the_title(get_option('page_for_posts', true)).$wrap_after;
		} elseif ( is_category() ) {
			$thisCat = get_category(get_query_var('cat'), false);
			if ($thisCat->parent != 0) {
				$cats = get_category_parents($thisCat->parent, TRUE);
				$cats = str_replace('<a', $wrap_before . '<a' . $linkAttr, $cats);
				$cats = str_replace('</a>', '</a>'.$strings_separator.$wrap_after, $cats);
				$html .= $cats;
			}
			$html .= $wrap_before.sprintf($strings_category, single_cat_title('', false)).$wrap_after;
	
		} elseif ( is_search() ) {
			$html .= $wrap_before.sprintf($strings_search, get_search_query()).$wrap_after;
	
		} elseif ( is_day() ) {
			$html .= $wrap_before.sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')).$wrap_after;
			$html .= $wrap_before.sprintf($link, get_month_link(get_the_time('Y'),get_the_time('m')), get_the_time('F')).$wrap_after;
			$html .= $wrap_before.get_the_time('d').$wrap_after;
	
		} elseif ( is_month() ) {
			$html .= $wrap_before.sprintf($link, get_year_link(get_the_time('Y')), get_the_time('Y')).$wrap_after;
			$html .= $wrap_before.get_the_time('F').$wrap_after;
	
		} elseif ( is_year() ) {
			$html .= $wrap_before.get_the_time('Y').$wrap_after;
	
		} elseif ( is_single() && !is_attachment() ) {
				$html .= $wrap_before.get_the_title(get_option('page_for_posts')).$wrap_after;
		} elseif(is_tax()){
				
			$html .= $wrap_before.wp_title(' ', false).$wrap_after ;
			
		}  elseif ( is_attachment() ) {
			$html .= $wrap_before.wp_title(' ', false).$wrap_after ;
	
		} elseif ( is_tag() ) {
			$html .= $wrap_before.sprintf($strings_tag, single_tag_title('', false)).$wrap_after;
	
		} elseif ( is_author() ) {
			global $author;
			$userdata = get_userdata($author);
			$html .= $wrap_before.sprintf($strings_author, $userdata->display_name).$wrap_after;
	
		} elseif ( is_404() ) {
			$html .=  $wrap_before.$strings_404.$wrap_after;
		}
		
		function checkForPaged(){
			if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) return true;
		}
	
		if ( get_query_var('paged') ) if ( checkForPaged() == true) $html .= ' ('.__('Page') . ' ' . get_query_var('paged').')';
		
		$html .= '</ul>';
		
		if ( function_exists('is_bbpress') ) {
			if ( is_bbpress() ) {
				$args = array(
					'home_text' => $strings_home,
					'before' => null,
					'after'  => null,
					'sep' => $strings_separator
				);
				ob_start(); bbp_breadcrumb( $args );
				$link = ob_get_clean();
				$html = '<ul class="theme-bc">'.$strings_before.'<li>'.sprintf($link, $home, $strings_home).'</li></ul>';
			}
		}
		
		if ( function_exists('is_woocommerce') ) {
			if ( is_woocommerce() ) {
				ob_start(); woocommerce_breadcrumb();
				$html = ob_get_clean();
			}
		}
		
		return ( $active == "true" ) ? $html : null;
	}

/*	Minify CSS
	================================================= */	
	public static function minify_css( $string ) {
		$string = preg_replace('!/\*.*?\*/!s','', $string);
		$string = preg_replace('/\n\s*\n/',"\n", $string);
		
		// space
		$string = preg_replace('/[\n\r \t]/',' ', $string);
		$string = preg_replace('/ +/',' ', $string);
		$string = preg_replace('/ ?([,:;{}]) ?/','$1',$string);
		
		// trailing;
		$string = preg_replace('/;}/','}',$string);
		
		return $string;
	}

/*	Generate Logo / Title
	================================================= */	
	public function get_logo(){
		$title 			= 	get_option(THEMEPREFIX.'_title', get_option('blogname'));
		$logo 			= 	get_option(THEMEPREFIX.'_logo');
		$logo_id 		= 	get_option(THEMEPREFIX.'_logo_id');
		$logo_retina 	= 	get_option(THEMEPREFIX.'_logo_retina');
		if (!$logo_retina) { $logo_retina = get_option(THEMEPREFIX.'_logo'); }
		$blog_title		= 	get_bloginfo('name');
		
		if( $logo ) { 
			if ( !$logo_id ) {
				$logo_path = preg_replace('/(http:\/\/.+)wp-content/','',$logo);
				$logo_path = WP_CONTENT_DIR.$logo_path;
				list($width, $height, $type, $attr) = getimagesize($logo_path);
			} else {
				$picture_details = wp_get_attachment_image_src($logo_id, 'full');
				$attr = ' width="'.$picture_details[1].'" height="'.$picture_details[2].'" ';
			}
			
			return '<div class="logo"><a href="'.home_url() .'" title="'.$blog_title.'"><img src="'.$logo.'" alt="'.$blog_title.'" class="logo-nonretina"><img src="'.$logo_retina.'" alt="'.$blog_title.'" '.$attr.' class="logo-retina"></a></div>'; 
		} else { 
			return '<h1 class="logo"><a href="'.home_url().'" title="'.$blog_title.'">'.$title.'<small>'.get_bloginfo('description').'</small></a></h1>'; 
		}
	}

/*	Page Heading
	================================================= */
	public function check_heading() {
	
		$heading = get_option(THEMEPREFIX.'_page_heading', 'true');
		
		if ( is_page() || is_single() ) {
			global $post;
			
			$heading_temp = get_post_meta($post->ID, THEMEPREFIX.'_heading', true);
			if ( empty( $heading_temp ) ) {
				$heading_temp = get_post_meta($post->ID, THEMEPREFIX.'page_heading', true);
			}
			
			if ( isset( $heading_temp ) ) {
				switch ( $heading_temp ) {
					case 'on' : $heading = 'false'; break;
					case 'true' : $heading = 'false'; break;
					case 'off' : $heading = 'true'; break;
				}
			}
		}
		
		return $heading;
	}
	
	public function get_page_heading($before, $after){
		
		global $post;
		
		$forum = ( class_exists('bbPress') ) ? true : false;
		
		if (is_page() || is_single() || is_attachment() ) 
			if( get_post_type() == "post" )
				$html = get_the_title(get_option('page_for_posts'));
			else
			$html = get_the_title();
		elseif	( is_home() )
			$html = get_the_title(get_option('page_for_posts', true) );
		elseif ( is_category() || is_tax() )
			$html = single_cat_title('' , false);
		elseif ( is_archive() && !$forum ){
			if ( is_day() ) :
				$html = sprintf( __( 'Daily Archives: %s', 'CURLYTHEME' ), '<span>' . get_the_date() . '</span>' );
			elseif ( is_month() ) :
				$html = sprintf( __( 'Monthly Archives: %s', 'CURLYTHEME' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'CURLYTHEME' ) ) . '</span>' );
			elseif ( is_year() ) :
				$html = sprintf( __( 'Yearly Archives: %s', 'CURLYTHEME' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'CURLYTHEME' ) ) . '</span>' );
			else :
				$html = __( 'Archives', 'CURLYTHEME' );
			endif;
		}
		elseif (is_search())
			$html = __('Search Results' , 'CURLYTHEME');
		elseif (is_404())
			$html = __('Page not found' , 'CURLYTHEME');	
		else
			$html = get_the_title();
		
		if ( function_exists('is_woocommerce') ) {
			if ( is_woocommerce() ) {
				if ( apply_filters( 'woocommerce_show_page_title', true ) ) {
					$html = woocommerce_page_title(false);
				}
			}
		}
		
		if ( !$before ) {
			$before = '<h1>';
		}
		if ( !$after ) {
			$after = '</h1>';
		}
			
		return $before.$html.$after;		
	}

/*	Page Title
	================================================= */
	function get_page_title(){
	
		global $post;
		
		$blog	= get_bloginfo('name');
		$desc	= get_bloginfo('description');
		
		if (is_single()) {
			
			$title  = get_post_meta($post->ID, THEMEPREFIX.'_seo_title', true);
			if ( empty( $title ) ) {
				$title  = get_post_meta($post->ID, 'seotitle', true);
			}
			$format	= get_option(THEMEPREFIX.'_seo_title_post', 0);
			
			if(!$title) $title = $title = $post->post_title;
			
			switch($format){
				case '0'	: 	$title =  $title; break;
				case '1' 	: 	$title =  $title.' | '.$blog; break;
				case '2' 	: 	$title =  $title.' | '.$desc; break;
			}
			
		} elseif ( is_page() ) {
			
			$title  = get_post_meta($post->ID, THEMEPREFIX.'_seo_title', true);
			if ( empty( $title ) ) {
				$title  = get_post_meta($post->ID, 'seotitle', true);
			}
			$format	= get_option(THEMEPREFIX.'_seo_title_page', 0);
			
			if(!$title) $title = $post->post_title;
			
			switch($format){
				case '0'	: 		$title = $title; break;
				case '1'	: 		$title = $title.' | '.$blog; break;
				case '2'	: 		$title = $title.' | '.$desc; break;
			}
		
		} elseif (is_category()) {
		
			$title  = single_cat_title('',false);
			$format	= get_option(THEMEPREFIX.'_seo_title_category', 1);
			$cate	= category_description();
			
			switch($format){
				case '1'	:  $title = $title.' | '.$blog; break;
				case '2'	:  $title = $title.' | '.$desc; break;
				case '3'   	:  $title = $title.' | '.strip_tags($cate); break;
			}
		
		
		} elseif (is_tag()){
			
			$title  = single_tag_title('',false);
			$format	= get_option(THEMEPREFIX.'_seo_title_tag', 1);
			
			switch($format){
				case '1'   	  :  $title = $title.' | '.$blog; break;
				case '2'	  :  $title = $title.' | '.$desc; break;
			}
		
		} elseif (is_search()){
			
			global $query_string;
			$title  = substr(strip_tags($query_string), 2);
			$format	= get_option(THEMEPREFIX.'_seo_title_search', 1);
			
			switch($format){
				case '1'   	   :  $title = $title.' | '.$blog; break;
				case '2'	   :  $title = $title.' | '.$desc; break;
			}
			
		}elseif ( is_archive() ){
			
			$title  = single_month_title('',false);
			$format	= get_option(THEMEPREFIX.'_seo_title_archive', 1);
			
			if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
			    if (is_shop()) {
			    	$title = get_the_title(get_option('woocommerce_shop_page_id'));
			    } else {
			    	if ( apply_filters( 'woocommerce_show_page_title', true ) ) {
			    		$title = woocommerce_page_title(false);
			    	}
			    }
			}
			
			switch($format){
				case '1'   	   :  $title = $title.' | '.$blog; break;
				case '2'	   :  $title = $title.' | '.$desc; break;
			}
		
		} elseif (is_404()){
			$title	= get_option(THEMEPREFIX.'_seo_title_search', __('404 Error. Page Not Found.', 'CURLYTHEME'));
		} elseif (is_home()){
			$title	= get_the_title(get_option('page_for_posts')).' | '.$blog;
		}
		
		if ( class_exists('bbPress') ) {
			$title = get_the_title().' | '.$blog;
		}
		
		return $title;
	}

/*	Pagination
	================================================= */	
	public static function get_pagination( $pages = null ){
	
		global $wp_query;
		global $paged;
		
		if($pages ==  null) $pages = $wp_query->max_num_pages;
		
		if($paged == 0) $paged++;
		if($pages > 1)
		{
		   $html = '<ul class="pagination">';
		   if($paged > 1) $html .= '<li><a class="pagination-prev" href="'.get_pagenum_link($paged - 1).'"><span>'.__('&laquo;', 'CURLYTHEME').'</span></a></li>';
		   for ($i=1; $i <= $pages; $i++){
			  $html .= ($paged == $i) ? '<li class="active"><span>'.$i.'</span></li>' : '<li><a href="'.get_pagenum_link($i).'" class="inactive">'.$i.'</a></li>';
		   }
		   if ($paged < $pages) $html .= '<li><a class="pagination-next" href="'.get_pagenum_link($paged + 1).'">'.__('&raquo;', 'CURLYTHEME').'</a></li>';  
		   $html .= '</ul>';
		   return $html;
	     }
		 else return null;
	}
	
/*	Curly Header
	================================================= */
	public function header() {
		switch (get_option(THEMEPREFIX.'_header_style', 0)) {
			case 0 : get_header(); break;
			case 1 : get_header('1'); break;
			case 2 : get_header('2'); break;
		}
	}

/*	Curly Footer
	================================================= */		
	public function footer() {
		get_footer();
	}

/*	Slider
	================================================= */
	public function slider() {
		$slider = new CurlyThemesSlider(); 
		$slider->slider();
	}
	
}

$curly = new CurlyThemes();

?>