<?php 

class CurlyThemesContact {
	
	public function __construct() {
		
		// Contact Form - Send Mail
		add_action( 'wp_ajax_contact_form_sender', array( $this, 'form_sender') );
		add_action( 'wp_ajax_nopriv_contact_form_sender', array( $this, 'form_sender') );
	}
	
	// Side Content
	public function side( $side ) {
		if (function_exists('curly_shortcode_sanitizer')) {
			echo do_shortcode( curly_shortcode_sanitizer( wpautop( $side ) ) );
		} else {
			echo do_shortcode( wpautop( $side ) );
		}
	}
	
	// Generate Map
	public function map( $latitude, $longitude, $height, $map_type, $marker, $zoom, $color ) {
		
		// Enqueue Map Scripts
		if( !wp_script_is('curly-google-maps') ) { 
			wp_enqueue_script('curly-google-maps');
		}
		if( !wp_script_is('curly-gmap3') ) { 
			wp_enqueue_script('curly-gmap3');
		}
	
		$html  = '<div class="map-container"><div id="map-contact" style="height: '.$height.'px;"></div></div>';
		$html .= '<script type="text/javascript">
					jQuery(document).ready(function(){
						jQuery("#map-contact").gmap3({
							map:{
								options:{
									center: ['.$latitude.','.$longitude.'],
									zoom: '.$zoom .',
									draggable: false,
									mapTypeControl: true,
									scrollwheel: false,
									mapTypeId: google.maps.MapTypeId.'.strtoupper($map_type).',
									'.(( $color ) ? 'styles: [{stylers: [{ hue: "'.$color.'" }]}]' : null ).'
								},
							},
							marker:{
								values:[{ latLng:['.$latitude.','.$longitude.'] ,
									'.( ( $marker ) ? 'options:{icon: "'.$marker.'"}' : null ).'
								}],
							}
						});
					});	
					</script>';
		
		echo $html;
	}
	
	public function side_box_position() {
		echo   "<script>			   
					jQuery(window).resize(function(){
						if(jQuery(window).width() > 700){
						jQuery('#contact-info').css({
							position:'absolute',
							top: ( jQuery('.map-holder').outerHeight() / 2 - jQuery('#contact-info').outerHeight() / 2),
							right: ( jQuery('.container > .row').position().left)
						});	
						}
					});
					jQuery(window).resize();
				</script>";
	}
	
	public function set_side_box_position() {
		add_action('wp_footer', array($this, 'side_box_position'), 21);
	}
	
	// Contact Form
	public function contact_form() {
		$html  = '<form name="contact-us" id="contact-form">';
		$html .= '<p><input type="text" name="name" placeholder="'.__('Enter your name *', 'CURLYTHEME').'" id="name" class="form-control" /></p>';
		$html .= '<p><input type="text" name="email" placeholder="'.__('Enter your email address *', 'CURLYTHEME').'" id="email" class="form-control" /></p>';
		$html .= '<p><textarea name="message" placeholder="'.__('Enter your message *', 'CURLYTHEME').'" id="message" rows="3" class="form-control"></textarea></p>';
		$html .= '<div class="message"></div>';
		$html .= '<div class="infoWrapper"><div class="infoContent"><input type="submit" value="'.__('Send Message', 'CURLYTHEME').'" class="btn" style="margin-top: 10px;" /></div></div>';
		$html .= '</form>';
		$html .= '<script type="text/javascript">';
		$html .= 	'jQuery(function(){
						jQuery("#contact-form input[type=submit]").click(function(e){
						
							e.preventDefault();
							
							jQuery(".message").removeClass("success").removeClass("error").addClass("loader").html("<i class=\'fa fa-spinner fa-spin\'></i> '.__('Sending message','CURLYTHEME').'").fadeIn("slow");
							
							var ajaxurl = "'.admin_url( 'admin-ajax.php' ).'";
							var dataString = new Array();
							
							dataString.push( jQuery("#name").val() );
							dataString.push( jQuery("#email").val() );
							dataString.push( jQuery("#message").val() );
							
							jQuery.post(
							    ajaxurl, 
							    {
							        "action": "contact_form_sender",
							        "data":   dataString
							    }, 
							    function( response ){
									switch( response ) {
										case "field_error":
											jQuery(".message").removeClass("loader").addClass("error");
											jQuery(".message").html("'.__('Please fill in all the required fields.','CURLYTHEME').'");
											break;
										case "email_error":
											jQuery(".message").removeClass("loader").addClass("error");
											jQuery(".message").html("'.__('Please fill a valid email address.','CURLYTHEME').'");
											break;
										case "success":
											jQuery(".message").removeClass("loader").addClass("success");
											jQuery(".message").html("'.__('Your message has been sent. You will soon hear from us!','CURLYTHEME').'");
											jQuery(".infoWrapper").remove();
											break;
										default:
											alert("'.__('Something is wrong. Please try again.', 'CURLYTHEME').'");
									}
							    }
							);
						});
					});';
		$html .= '</script>';
		
		echo $html;
	}

	public function form_sender() {
	
		$name 	= $_POST['data'][0];
		$mes 	= $_POST['data'][2];
		$email 	= $_POST['data'][1];
		
		$subject = 'Contact Form: '.get_bloginfo('name');
		
		$headers  = "From: ". strip_tags($name) . ' <'.strip_tags($email).">" . "\r\n";
		$headers .= "Reply-To: ". strip_tags($email) . "\r\n";
		$headers .= "MIME-Version: 1.0\r\n";
		$headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";
		
		$message  = '<html><body>';
		$message .= '<table rules="all" style="border-color: #666;" cellpadding="10">';
		$message .= "<tr style='background: #eee;'><td><strong>Name:</strong> </td><td><strong>" . strip_tags($name) . "</strong></td></tr>";
		$message .= "<tr><td><strong>Email:</strong> </td><td>" . strip_tags($email) . "</td></tr>";
		$message .= "<tr><td><strong>Message:</strong> </td><td>" . strip_tags($mes) . "</td></tr>";
		$message .= "</table>";
		$message .= "</body></html>";
		
		if( empty($name) || empty($mes) || empty($email) ) {
		
			$result = "field_error";
			
		} elseif( !is_email($email) ) {
		
			$result = "email_error";
			
		} else {
			mail(get_option(THEMEPREFIX.'_general_email'), $subject , $message, $headers);
			$result = "success";
		}
		
		echo $result;
		
		die();
	}
}

$contact = new CurlyThemesContact();

?>