<?php

/*	Main CSS
    ================================================= */ 
	function curly_custom_css() {
	
	$output = null;

/*	Font Sizes
	================================================= */
	$font_body = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_body', 29), 
		get_option(THEMEPREFIX.'_fonts_body_size', 14), 
		get_option(THEMEPREFIX.'_fonts_body_style', 0), 
		get_option(THEMEPREFIX.'_fonts_body_variant', 0)
	);
	
	$font_h1 = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_h1', 53), 
		get_option(THEMEPREFIX.'_fonts_h1_size', 36), 
		get_option(THEMEPREFIX.'_fonts_h1_style', 3), 
		get_option(THEMEPREFIX.'_fonts_h1_variant', 0)
	);

	$font_h2 = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_h2', 53), 
		get_option(THEMEPREFIX.'_fonts_h2_size', 36), 
		get_option(THEMEPREFIX.'_fonts_h2_style', 0), 
		get_option(THEMEPREFIX.'_fonts_h2_variant', 0)
	);
	
	$font_h3 = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_h3', 53), 
		get_option(THEMEPREFIX.'_fonts_h3_size', 24), 
		get_option(THEMEPREFIX.'_fonts_h3_style', 3), 
		get_option(THEMEPREFIX.'_fonts_h3_variant', 0)
	);
	
	$font_h4 = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_h4', 53), 
		get_option(THEMEPREFIX.'_fonts_h4_size', 18), 
		get_option(THEMEPREFIX.'_fonts_h4_style', 2), 
		get_option(THEMEPREFIX.'_fonts_h4_variant', 2)
	);
	
	$font_h5 = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_h5', 53), 
		get_option(THEMEPREFIX.'_fonts_h5_size', 15), 
		get_option(THEMEPREFIX.'_fonts_h5_style', 3), 
		get_option(THEMEPREFIX.'_fonts_h5_variant', 0)
	);
	
	$font_h6 = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_h6', 53), 
		get_option(THEMEPREFIX.'_fonts_h6_size', 15), 
		get_option(THEMEPREFIX.'_fonts_h6_style', 3), 
		get_option(THEMEPREFIX.'_fonts_h6_variant', 0)
	);
	
	$font_blockquote = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_blockquote', 29), 
		get_option(THEMEPREFIX.'_fonts_blockquote_size', 14), 
		get_option(THEMEPREFIX.'_fonts_blockquote_style', 4), 
		get_option(THEMEPREFIX.'_fonts_blockquote_variant', 0)
	);
	
	$font_menu = new CurlyThemesFont(
		get_option(THEMEPREFIX.'_fonts_menu', 53), 
		get_option(THEMEPREFIX.'_fonts_menu_size', 16), 
		get_option(THEMEPREFIX.'_fonts_menu_style', 3), 
		get_option(THEMEPREFIX.'_fonts_menu_variant', 2)
	);

/*	Colors
	================================================= */
	$color_menu 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_menu_bg_top') );
	$color_menu_link 		= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_menu_text') );
	$color_menu_hover 		= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_menu_hover_text') );
	$color_submenu 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_menu_submenu') ); 
	$color_submenu_link 	= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_submenu_text') ); 
	$color_submenu_hover 	= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_submenu_hover_text') );
	$color_footer_text 		= new CurlyThemesColor( get_option(THEMEPREFIX.'_footer_text_color') );
	$color_footer_link 		= new CurlyThemesColor( get_option(THEMEPREFIX.'_footer_link_color') );
	$color_footer_title 	= new CurlyThemesColor( get_option(THEMEPREFIX.'_footer_title_color') );
	$color_primary 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_primary') );
	$color_text 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_text') );
	$color_link 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_links') );
	$color_hover 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_links_hover') );
	$body_bg_color 			= new CurlyThemesColor( get_option(THEMEPREFIX.'_bg_color') );
	$color_h1 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h1') );
	$color_h2 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h2') );
	$color_h3 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h3') );
	$color_h4 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h4') );
	$color_h5 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h5') );
	$color_h6 				= new CurlyThemesColor( get_option(THEMEPREFIX.'_color_h6') );
	

/*	Load Background
	================================================= */
	$bg_pattern 	= get_option(THEMEPREFIX.'_bg_pattern', 11) ;
	$bg_image 		= get_option(THEMEPREFIX.'_bg_image') ;
	$bg_repeat 		= get_option(THEMEPREFIX.'_bg_repeat') ;
	$bg_position	= get_option(THEMEPREFIX.'_bg_position') ;
	$bg_fixed 		= get_option(THEMEPREFIX.'_bg_fixed') ;
	
	switch($bg_pattern){
		case 1  : $bg_pat = 'bg-01.jpg'; $bg_pat_retina = 'bg-01@2X.jpg'; $bg_pat_size = '500px 333px'; break;
		case 2  : $bg_pat = 'bg-02.png'; $bg_pat_retina = 'bg-02@2X.png'; $bg_pat_size = '16px 16px'; break;
		case 3  : $bg_pat = 'bg-03.jpg'; $bg_pat_retina = 'bg-03@2X.jpg'; $bg_pat_size = '500px 500px'; break;
		case 4  : $bg_pat = 'bg-04.jpg'; $bg_pat_retina = 'bg-04@2X.jpg'; $bg_pat_size = '188px 188px'; break;
		case 5  : $bg_pat = 'bg-05.jpg'; $bg_pat_retina = 'bg-05@2X.jpg'; $bg_pat_size = '250px 250px'; break;
		case 6  : $bg_pat = 'bg-06.jpg'; $bg_pat_retina = 'bg-06@2X.jpg'; $bg_pat_size = '588px 375px'; break;
		case 7  : $bg_pat = 'bg-07.jpg'; $bg_pat_retina = 'bg-07@2X.jpg'; $bg_pat_size = '200px 200px'; break;
		case 8  : $bg_pat = 'bg-08.jpg'; $bg_pat_retina = 'bg-08@2X.jpg'; $bg_pat_size = '304px 306px'; break;
		case 9  : $bg_pat = 'bg-09.jpg'; $bg_pat_retina = 'bg-09@2X.jpg'; $bg_pat_size = '400px 343px'; break;
		case 10 : $bg_pat = 'bg-10.jpg'; $bg_pat_retina = 'bg-10@2X.jpg'; $bg_pat_size = '50px 197px'; break;
		case 11 : $bg_pat = 'bg-11.jpg'; $bg_pat_retina = 'bg-11@2X.jpg'; $bg_pat_size = '50px 197px'; break;
	}
	
/*	Custom Fonts
	================================================= */
	$woff	=	get_option(THEMEPREFIX.'_font_upload_woff');
	$ttf	=	get_option(THEMEPREFIX.'_font_upload_ttf');
	$svg	=	get_option(THEMEPREFIX.'_font_upload_svg');
	$eot	=	get_option(THEMEPREFIX.'_font_upload_eot');

	if($woff && $ttf && $svg && $eot) {
		$output .= '@font-face {
						font-family: \'Custom Uploaded Font\';
						src: url(\''.$eot.'\');
						src: '.((strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome') !== false) ? 'url(\''.$woff.'\') format(\'woff\'),' : null).'
							url(\''.$eot.'?#iefix\') format(\'embedded-opentype\'),
							url(\''.$svg.'#Custom%20Uploaded%20Font\') format(\'svg\'),
							'.((strpos($_SERVER['HTTP_USER_AGENT'], 'Chrome') == false) ? 'url(\''.$woff.'\') format(\'woff\'),' : null).'
							url(\''.$ttf.'\') format(\'truetype\');
						font-weight: normal;
						font-style: normal;
					}';
	}
	

/*	General
	================================================= */
	$output .= (get_option(THEMEPREFIX.'_general_responsive', 'true') == 'true' ) ? null : '.container { width: 1170px !important; max-width: none !important}' ;
	$output .= 'body{
					color: '.$color_text.';
					background-color:		'.$body_bg_color.';';
					if($bg_pattern == 0) {
						$output .= ($bg_image) ? 'background-image: url(\''.$bg_image.'\');' : null;
						$output .= ($bg_repeat) ? 'background-repeat: '.$bg_repeat.';' : null;
						$output .= ($bg_position) ? 'background-position: '.$bg_position.';' : null;
						$output .= ($bg_fixed == 'true') ? 'background-attachment: fixed;' : null;
					} else {
						$output .= 'background: url(\''.get_template_directory_uri() .'/images/bg/'.$bg_pat.'\') repeat;';
					}
	$output .= '}';
	
	$output .= 'body a,
				a:visited,
				a.btn-link,
				a.btn-link:visited,
				.button{
					color: '.$color_link.';
				}
				a:hover,
				a.btn-link:hover{
					color: '.$color_hover.';
				}
				.btn-link{
					border: 2px solid '.$color_link.';
				}
				.btn-link:hover{
					border: 2px solid '.$color_hover.';
				}';
	$output .= 'input[type="text"],
				input[type="email"],
				input[type="password"],
				textarea,
				textarea.form-control,
				.wp-editor-container{
					border: 1px solid '.$color_text->opacity(0.25).';
				}';			
	
	if( get_option( THEMEPREFIX.'_general_wide', null ) != "true" ){
		$output .= '.site{
						max-width: 1200px;
						'.((get_option(THEMEPREFIX.'_general_align') == "true") ? 'margin: 0' : 'margin: 0 auto').'
					}
					.site .stuck,
					.site header,
					.site footer::before{
						max-width: 1200px
					}
					.site header.header-01 .stuck,
					.site header.header-02 .stuck{ 
						max-width: 100% 
					}';
	}
	
	$output .= '*::selection {
					background: '.$color_primary.';
					color: '.$color_primary->contrast('#FFFFFF', '#000000').';
				}
				*::-moz-selection {
					background: '.$color_primary.';
					color: '.$color_primary->contrast('#FFFFFF', '#000000').';
				}';
	
/*	Header
	================================================= */
	switch (get_option(THEMEPREFIX.'_header_shading_pattern', 1)) {
		case 0 : $shading_img = 'bg-header-none.png'; break;
		case 1 : $shading_img = 'bg-header.png'; break;
		case 2 : $shading_img = 'bg-header-02.png'; break;
		case 3 : $shading_img = 'bg-header-03.png'; break;
		case 4 : $shading_img = 'bg-header-04.png'; break;
		case 5 : $shading_img = 'bg-header-05.png'; break;
		case 6 : $shading_img = 'bg-header-06.png'; break;
		case 7 : $shading_img = 'bg-header-07.png'; break;
		case 8 : $shading_img = 'bg-header-08.png'; break;
		case 9 : $shading_img = 'bg-header-09.png'; break;
		case 10: $shading_img = 'bg-header-10.png'; break;
		default: $shading_img = 'bg-header.png';
	}
	
	$header_bg 		= new CurlyThemesColor( get_option(THEMEPREFIX.'_header_shading_color', '#000000'));
	$header_text 	= new CurlyThemesColor( get_option(THEMEPREFIX.'_header_text_color', $header_bg->contrast('#FFFFFF', '#000000')));
	$menu_hover		= get_option(THEMEPREFIX.'_hover_menu');
	
	if ( get_header_image() ) {
		$output .= '#header { background-image: url('.get_header_image().'); }';
	}
	$output .= '#header,
				#header h1,
				#header small,
				#header .logo a{
					color: '.$header_text.';
				}
				#header-holder{
					background-color: '.$header_bg->opacity( (get_option(THEMEPREFIX.'_header_shading_opacity', 55) / 100) ).';
					background-image: url(\''.get_template_directory_uri() .'/images/header/'.$shading_img.'\');
				}';
	
	$output .= '#header .logo{
					margin: '.get_option(THEMEPREFIX.'_header_margin_top').'px 0 '.get_option(THEMEPREFIX.'_header_margin_bottom').'px 0;
				}
				#header #navigation{
					background: '.( !empty($color_menu) ? $color_menu : 'transparent' ).'
				}
				#header #navigation.stuck{
					background: '.( !empty($color_menu) ? $color_menu : $header_bg ).'
				}';		
	if ( $menu_hover != "true" ) {
		$output	.= '#navigation a{ color: '.$color_menu_link.'}
					#navigation ul ul{ background: '.$color_submenu.'; border-left: 5px solid '.$color_submenu_link->opacity(0.2).';}
					#navigation ul ul a{
						color: '.$color_submenu_link.';
						border-bottom: 1px solid '.$color_submenu_link->opacity(0.1).';
					}
					#navigation ul ul a:hover{
						color: '.$color_submenu_hover.';
					}
					#navigation > div > ul > li.current-menu-item > a,
					#navigation > div > ul > li.current_page_ancestor > a,
					#navigation > div > ul > li.current_page_parent > a{
						color: '.$color_menu_hover.'
					}
					#navigation > div > ul > li.current-menu-item > a:after,
					#navigation > div > ul > li.current_page_ancestor > a:after,
					#navigation > div > ul > li.current_page_parent > a:after{
						color: '.$color_menu.'
					}';
	} else {
		$output	.= '#navigation a{ color: '.$color_menu_link.'}
					#navigation a:hover{ color: '.$color_menu_hover.'}
					#navigation ul ul{ background: '.$color_submenu.'; border-left: 5px solid '.$color_submenu_link->opacity(0.2).';}
					#navigation ul ul a{
						color: '.$color_submenu_link.';
						border-bottom: 1px solid '.$color_submenu_link->opacity(0.1).';
					}
					#navigation ul ul a:hover{
						color: '.$color_submenu_hover.';
					}
					#navigation > div > ul > li.current-menu-item > a,
					#navigation > div > ul > li.current_page_ancestor > a,
					#navigation > div > ul > li.current_page_parent > a{
						color: '.$color_menu_hover.'
					}
					#navigation > div > ul > li.current-menu-item > a:after,
					#navigation > div > ul > li.current_page_ancestor > a:after,
					#navigation > div > ul > li.current_page_parent > a:after{
						color: '.$color_menu.'
					}';
	}
	if ( is_admin_bar_showing() ){
		$output .= '.stuck{ top: 32px }';
	}			
	

/*	Header 01
	================================================= */
	$output .= '#page-heading.header-01{
					border-bottom: 1px solid '.$color_text->opacity(0.1).';
				}
				#header.header-01 #header-holder{
					padding: '.get_option(THEMEPREFIX.'_header_margin_top').'px 0 '.get_option(THEMEPREFIX.'_header_margin_bottom').'px 0;
					border-bottom: 5px solid '.$color_primary.';
				}
				#header.header-01 .stuck{
					background: '.$color_menu.' !important
				}';	

/*	Header 02
	================================================= */
	$output .= '#header.header-01.header-02 #header-holder{
					padding: 10px 0 '.get_option(THEMEPREFIX.'_header_margin_bottom').'px 0;
					border-bottom: 5px solid '.$color_primary.';
				}
				#header.header-01.header-02 .container:first-of-type{
					margin-bottom: '.get_option(THEMEPREFIX.'_header_margin_top').'px;
				}
				#header.header-01.header-02 hr{
					border-color: rgba('.$header_text.', .35)
				}';												

/*	Footer
	================================================= */
	$footer_bg_image 	= get_option(THEMEPREFIX.'_bg_footer_image', null);
	$footer_bg_repeat 	= get_option(THEMEPREFIX.'_bg_footer_repeat', null);
	$footer_bg_position = get_option(THEMEPREFIX.'_bg_footer_position', null);
	$footer_bg = new CurlyThemesColor( get_option(THEMEPREFIX.'_footer_bg_color', null) );
	$footer_bg = $footer_bg->color();
	
	$output .= 'footer{
					padding: '.get_option(THEMEPREFIX.'_footer_margin', 40).'px 0 '.get_option(THEMEPREFIX.'_footer_margin_bottom', 60).'px 0;
					color: '.$color_footer_text.';
					'.(( $footer_bg ) ? 'background-color: '.$footer_bg.';background-image: none;' : null ).'
					'.(($footer_bg_image) ? 'background-image:url(\''.$footer_bg_image.'\');' : null).'
					'.(($footer_bg_image) ? 'background-repeat: '.$footer_bg_repeat.';' : null).'
					'.(($footer_bg_image) ? 'background-position: '.$footer_bg_position.';' : null).'
				}';
	
	$output .= 'footer a, footer a:visited{ color: '.$color_footer_text.'}
				footer a:hover{ color: '.$color_footer_link.' }
				footer h5{ color: '.$color_footer_title.'}
				footer .special-title{ border-color: '.$color_footer_text->opacity(0.3).'}
				
				footer::before{
					margin-top: '.(-(int)(get_option(THEMEPREFIX.'_footer_margin', 40)) - 50).'px;
					'.( ($footer_bg_image || $footer_bg ) ? 'display: none;' : null ).'
				}
				.footer + .absolute-footer .col-lg-12:first-child{
					border-top: 1px solid '.$color_footer_text->opacity(0.3).';
					padding-top: 40px;
					margin-top: 10px;
				}
				.pre-footer{
					background: '.$color_text->opacity(0.07).';
				}
				
				#back-top a{
					background: '.$color_text->opacity(0.8).';
					color: '.$color_text->contrast('#000000', '#FFFFFF').'
				}
				#back-top a:hover{
					background: '.$color_text .'
				}';

/*	Typography
	================================================= */
	$output .= 'body, ul, li, p, input, textarea, select{
		font-family: \''.$font_body->_family.'\', sans-serif;
		font-size: '.$font_body->_size.'px;
		line-height: '.ceil(($font_body->_size * 1.5)).'px;
		'.$font_body->_style.$font_body->_variant.'
	}
	h1{
		color: '.$color_h1.';
		font-family: '.$font_h1->_family.', sans-serif;
		font-size: '.($font_h1->_size).'px;
		line-height: '.ceil($font_h1->_size * 1.2).'px;
		'.$font_h1->_style.$font_h1->_variant.'
	}
	h2{
		color: '.$color_h2.';
		font-family: '.$font_h2->_family.', sans-serif;
		font-size: '.ceil($font_h2->_size).'px;
		line-height: '.ceil($font_h2->_size * 1.2).'px;
		'.$font_h2->_style.$font_h2->_variant.'
	}
	h3{
		color: '.$color_h3.';
		font-family: '.$font_h3->_family.', sans-serif;
		font-size: '.ceil($font_h3->_size).'px;
		line-height: '.ceil($font_h3->_size * 1.2).'px;
		'.$font_h3->_style.$font_h3->_variant.'
	}
	h4{
		color: '.$color_h4.';
		font-family: '.$font_h4->_family.', sans-serif;
		font-size: '.ceil($font_h4->_size).'px;
		line-height: '.ceil($font_h4->_size * 1.35).'px;
		'.$font_h4->_style.$font_h4->_variant.'
	}
	h5{
		color: '.$color_h5.';
		font-family: '.$font_h5->_family.', sans-serif;
		font-size: '.ceil($font_h5->_size).'px;
		line-height: '.ceil($font_h5->_size * 1.35).'px;
		'.$font_h5->_style.$font_h5->_variant.'
	}
	h6{
		color: '.$color_h6.';
		font-family: '.$font_h6->_family.', sans-serif;
		font-size: '.ceil($font_h6->_size).'px;
		line-height: '.ceil($font_h6->_size * 1.35).'px;
		'.$font_h6->_style.$font_h6->_variant.'
	}
	#navigation li a{
		font-family: '.$font_menu->_family.', sans-serif;
		font-size: '.$font_menu->_size.'px;
		line-height: '.ceil($font_menu->_size * 1.5).'px;
		'.$font_menu->_style.$font_menu->_variant.'
	}
	#navigation li li a{
		font-size: '.ceil($font_menu->_size*0.9).'px;
		line-height: '.ceil($font_menu->_size * 1.5).'px;
	}
	blockquote,
	blockquote p,
	.blockquote,
	.blockquote p{
		font-family: '.$font_blockquote->_family.', sans-serif;
		font-size: '.ceil($font_blockquote->_size).'px;
		line-height: '.ceil($font_blockquote->_size * 1.5).'px;
		'.$font_blockquote->_style.$font_blockquote->_variant.'
	}
	.btn, .btn-link,
	input[type="button"],
	input[type="submit"],
	.button{
		font-family: '.$font_menu->_family.', sans-serif;
	}';

/*	Theme Features
	================================================= */
	$output .= '.special-title{ border-color: '.$color_text->opacity(0.2).'}
				.special-title:after{ border-color: '.$color_primary.'}';	

/*	WordPress Classes
	================================================= */
	$output .= '.avatar{
					-webkit-border-radius: 300px;
					-moz-border-radius: 300px;
					border-radius: 300px;
				}
				article table td{
					border-bottom: 1px solid '.$color_text->opacity(0.05).';
				}
				article table thead  th{
					border-bottom: 4px solid '.$color_primary.';
				}    
				article table tfoot td{
					border-top: 4px solid '.$color_text->opacity(0.05).';
				}
				article table tbody tr:hover td{
					background: '.$color_text->opacity(0.05).' !important;
				}    
				.bypostauthor .comment div{
					background: '.$color_text->opacity(0.05).');
				}';		

/*	Blog
	================================================= */
	$output .= '.post-calendar-date{
					background: '.$color_text->contrast("#000000", '#FFFFFF').';
					color: '.$color_text.';
				}
				.post-calendar-date em{
					color: '.$color_primary.';
				}
				.meta-data{
					font-size: '.($font_body->_size * 0.85).'px;
					color: '.$color_link.';
				}
				.single .meta-data{
					font-size: '.$font_body->_size.'px;
				}
				.blog-sort{
					background: '.$color_text->opacity(0.07).';
				}
				#blog-entries .sticky{
					background: '.$color_text->opacity(0.07).';
					padding: 20px;
					-webkit-border-radius: 3px;
					-moz-border-radius: 3px;
					border-radius: 3px;
				}
				#filters a{
					color: '.$color_text.';
				}
				#filters a:hover,
				#filters a.active:before{
					color: '.$color_link.';
				}
				.nav-links {
					color: '.$color_text.'
				}
				ul.pagination > li > a,
				ul.pagination > li > span{
					border-color: '.$color_text->opacity(0.15).';
					border-top: none;
					border-bottom: none;
					border-left: none;
					background: '.$color_text->opacity(0.07).';
					font-weight: bold;
					color: '.$color_text.';
				}
				ul.pagination > li > a:hover{
					background: '.$color_text->opacity(0.15).';
				}
				ul.pagination > li:last-child a{
					border-right: none
				}
				ul.pagination > .active > a,
				ul.pagination > .active > span,
				ul.pagination > .active:hover > span{
					background: '.$color_menu.';
					border-color: '.$color_menu.';
					color: '.$color_menu->contrast('#000000', '#FFFFFF').';
				}
				.tag-list span{
					color: '.$color_link.';
				}
				.social-box{
					background: '.$color_text->opacity(0.05).';
					-webkit-border-radius: 3px;
					-moz-border-radius: 3px;
					border-radius: 3px;
				}
				.about-author{
					border-top: 4px solid '.$color_primary.';
					border-bottom: 1px solid '.$color_text->opacity(0.2).';
				}
				.comment > div{
					border: 1px solid '.$color_text->opacity(0.2).';
					-webkit-border-radius: 3px;
					-moz-border-radius: 3px;
					border-radius: 3px;
				}
				#commentform input[type="submit"]{
					background: '.$color_primary.';
					border:1px solid '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
					-webkit-border-radius: 3px;
					-moz-border-radius: 3px;
					border-radius: 3px;
				}
				.label-format{ background: '.$color_primary.'; color: '.$color_primary->contrast('#000000', '#FFFFFF').' }';	

/*	Icons
	================================================= */	
	$output .= '.fa-boxed{
					background-color: '.$color_text->opacity(0.5).';
					color: '.$color_text->contrast('#000000', '#FFFFFF').';
				}
				a:hover .fa-boxed{
					background-color: '.$color_link.';
					color: '.$color_link->contrast('#000000', '#FFFFFF').';
				}';								

/*	Custom Recent Posts
	================================================= */
	$output .= '.recent-posts time{
					background: '.$color_text->contrast('#000000', '#FFFFFF').';
					color: '.$color_text.';
				}
				.recent-posts time em{
					color: '.$color_primary.';
				}
				.recent-posts h6{
					line-height: '.($font_h6->_size * 1.2).'px;
				}
				.recent-posts h6 + span a{
					color: '.$color_text.';
					font-size: '.($font_body->_size * 0.85).'px;
				}';			

/*	Media Queries - Landscape phones and down
	================================================= */	
	$output .= '@media (max-width: 767px) {
					#navigation a{ 
						padding: 10px 20px; 
						border-bottom: 1px solid '.$color_menu_link->opacity(0.2).'
					}
					#navigation ul ul,
					#navigation ul li:hover > ul{
						background: '.$color_menu->darken(10).';
					}
					#navigation ul ul a,
					#navigation ul ul li:last-child > a{
						color: '.$color_menu_link.'!important;
						border-bottom: 1px solid '.$color_menu_link->opacity(0.2).';
					}
					.nav-click{
						border-left: 1px solid '.$color_menu_link->opacity(0.2).'
					}
					#header.header-01 #navigation{
						background: '.$color_menu.'
					}
					#header.header-01 .table-cell{
						margin-bottom: '.get_option(THEMEPREFIX.'_header_margin_bottom').'px ;
						margin-top: '.get_option(THEMEPREFIX.'_header_margin_top').'px ;
					}			
				}';

/*	3rd Party - WooCommerce
	================================================= */
	if ( function_exists('is_woocommerce') ) {
	
	$output .= '.woocommerce div.product .woocommerce-tabs ul.tabs li.active, 
				.woocommerce-page div.product .woocommerce-tabs ul.tabs li.active{
					background: '.$color_text->opacity(0.07).' !important;
					color: '.$color_text.';
				}
				.woocommerce #reviews #comments ol.commentlist li .comment-text, .woocommerce-page #reviews #comments ol.commentlist li .comment-text{
					border-color: '.$color_text->opacity(0.2).';
				}
				.woocommerce span.onsale, .woocommerce-page span.onsale{
					background: '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
				}
				.woocommerce .star-rating span{
					color: '.$color_primary.';
				}
				.woocommerce .star-rating:before, .woocommerce-page .star-rating:before{
					color: '.$color_text->opacity(0.2).';
				}
				.woocommerce #payment, .woocommerce-page #payment{
					background: '.$color_text->opacity(0.07).' !important;
				}';
				
	}
	
/*	3rd Party - BBPress
	================================================= */
	if ( function_exists('is_bbpress') ) {
	
	$output .= '#bbpress-forums li.bbp-header{
					background: '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
				}
				#bbpress-forums li.bbp-header li,
				#bbpress-forums li.bbp-header div{
					font-family: '.$font_h5->_family.', sans-serif;
					font-size: '.ceil($font_h5->_size).'px;
					line-height: '.ceil($font_h5->_size * 1.2).'px;
					'.$font_h5->_style.$font_h5->_variant.'
				}
				#bbpress-forums li.bbp-header a{
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
				}
				#bbpress-forums li.bbp-body{
					border-bottom: 3px solid '.$color_primary.';
					border-left: 1px solid '.$color_text->opacity(0.075).';
					border-right: 1px solid '.$color_text->opacity(0.075).';
				}
				#bbpress-forums div.odd, 
				#bbpress-forums ul.odd{
					background: '.$color_text->opacity(0.075).';
				}
				#bbpress-forums .bbp-forums-list{
					border-left-color: '.$color_primary.';
				}
				#bbpress-forums fieldset.bbp-form{
					border-color: '.$color_text->opacity(0.15).';
				}
				#bbpress-forums div.bbp-forum-header, 
				#bbpress-forums div.bbp-topic-header, 
				#bbpress-forums div.bbp-reply-header{
					background: '.$color_primary.';
					border: 1px solid '.$color_primary.';
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
				}
				#bbpress-forums div.bbp-forum-header a, 
				#bbpress-forums div.bbp-topic-header a, 
				#bbpress-forums div.bbp-reply-header a{
					color: '.$color_primary->contrast('#000000', '#FFFFFF').';
				}
				#bbpress-forums .bbp-replies .bbp-content{
					border-left: 1px solid '.$color_text->opacity(0.15).';
					border-right: 1px solid '.$color_text->opacity(0.15).';
					border-bottom: 1px solid '.$color_text->opacity(0.15).';
				}
				.bbp-reply-post-date{
					border-top: 1px solid '.$color_text->opacity(0.15).';
				}
				.bbp-reply-ip{
					border-top: 1px solid '.$color_text->opacity(0.15).';
				}
				#bbpress-forums #bbp-single-user-details #bbp-user-navigation li.current a{
					background: '.$color_text->opacity(0.75).';
				}
				#bbp-single-user-details{
					border-bottom: 1px solid '.$color_text->opacity(0.15).';
				}';	
	}		

/*	Custom CSS
	================================================= */
	if( get_option( THEMEPREFIX.'_hover_menu', null ) == 'true') {
		$output .= '#menu-overlay{ display: none !important }';
	}
			
	$output .=  htmlspecialchars_decode( get_option( THEMEPREFIX . '_custom_css' ) );
			
	// Return Output
	return $output;	

	}


/*	Header Individual Page Settings
    ================================================= */     
    function curly_individual_page_settings_css() {

    	global $post;
    	
    	if ( is_single() || is_page() ) {
			$post_id = $post->ID;
    	} elseif ( curly_is_blog() && !is_single() ) {
    		$post_id = get_option( 'page_for_posts' );
    	} else {
    		$post_id = null;
    	}
    	
    	if ( !is_null($post_id) ) {
    	
    	// Background Options
    	$bg_color	= new CurlyThemesColor( get_post_meta( $post_id, THEMEPREFIX . '_bg_color' , true ) );
    	$bg_img 	= get_post_meta( $post_id, THEMEPREFIX . '_bg_image' , true );
		$bg_pos 	= get_post_meta( $post_id, THEMEPREFIX . '_bg_position' , true );
		$bg_rep 	= get_post_meta( $post_id, THEMEPREFIX . '_bg_repeat' , true );
		$bg_size 	= get_post_meta( $post_id, THEMEPREFIX . '_bg_size' , true );
		$bg_att 	= get_post_meta( $post_id, THEMEPREFIX . '_bg_attachment' , true );
    	
    	$bg_color	= $bg_color->color();
    	
    	// Header CSS Variables
    	$header_text	= new CurlyThemesColor( get_post_meta( $post_id, THEMEPREFIX . '_header_text' , true ) );
    	$header_bg	 	= new CurlyThemesColor( get_post_meta( $post_id, THEMEPREFIX . '_header_bg_color' , true ) );
    	$heading_color 	= new CurlyThemesColor( get_post_meta( $post_id, THEMEPREFIX . '_heading_color' , true ) );
    	$header_img		= new CurlyGetValue( 'meta', THEMEPREFIX . '_header_image', null, THEMEPREFIX . 'page_settings_heading_image', $post_id );
    	$header_img_id	= new CurlyGetValue( 'meta', THEMEPREFIX . '_header_image_id', null, THEMEPREFIX . 'page_settings_heading_image_id', $post_id );
    	$header_lg 		= new CurlyGetValue( 'meta', THEMEPREFIX . '_header_image_large', null, THEMEPREFIX . 'large_header', $post_id );
    	$header_opac	= get_post_meta( $post_id, THEMEPREFIX . '_header_opacity' , true );
    	$header_top		= get_post_meta( $post_id, THEMEPREFIX . '_header_margin_top' , true );
    	$header_bot		= get_post_meta( $post_id, THEMEPREFIX . '_header_margin_bottom' , true );
    	
    	$header_text	= $header_text->color();
    	$heading_color	= $heading_color->color();
    	
    	$header_img		= $header_img->result();
    	$header_img_id	= $header_img_id->result();
    	$header_lg		= $header_lg->result();
    	
    	// Slider
    	$slider 		= new CurlyGetValue( 'meta', THEMEPREFIX . '_slider', null, THEMEPREFIX . 'slider', $post_id );
    	$slider_push 	= new CurlyGetValue( 'meta', THEMEPREFIX . '_slider_push', null, THEMEPREFIX . 'header_push', $post_id );
    	
    	$slider 		= $slider->result();
    	$slider_push	= $slider_push->result();
    	
    	// Initialize $html
    	$html = null;
    	
    	// Body Background Color
    	if ( isset( $bg_color ) && !empty( $bg_color ) ) {
    		$html .= 'body { background: none; background-color: '.$bg_color.' }';
    	}
    	
    	
    	// Body Background Image
    	if ( isset( $bg_img ) && !empty( $bg_img ) ) {
    		$html .= 'body { background-image: url("'.$bg_img.'") }';
    		
    		// Body Background Position
    		if ( isset( $bg_pos ) && !empty( $bg_pos ) ) {
    			switch ( $bg_pos ) {
    				case 1 : $bg_pos = 'top center'; break;
    				case 2 : $bg_pos = 'top right'; break;
    				case 3 : $bg_pos = 'center left'; break;
    				case 4 : $bg_pos = 'center center'; break;
    				case 5 : $bg_pos = 'center right'; break;
    				case 6 : $bg_pos = 'bottom left'; break;
    				case 7 : $bg_pos = 'bottom center'; break;
    				case 8 : $bg_pos = 'bottom right'; break;
    			}
    			$html .= 'body { background-position: '.$bg_pos.' }';
    		}
    		
    		// Body Background Repeat
    		if ( isset( $bg_rep ) && !empty( $bg_rep ) ) {
    			switch ( $bg_rep ) {
    				case 1 : $bg_rep = 'no-repeat'; break;
    				case 2 : $bg_rep = 'repeat-y'; break;
    				case 3 : $bg_rep = 'repeat-x'; break;
    			}
    			$html .= 'body { background-repeat: '.$bg_rep.' }';
    		}
    		
    		// Body Background Size
    		if ( isset( $bg_size ) && !empty( $bg_size ) ) {
    			switch ( $bg_size ) {
    				case 1 : $bg_size = 'cover'; break;
    				case 2 : $bg_size = 'contain'; break;
    			}
    			$html .= 'body { background-size: '.$bg_size.' }';
    		}
    		
    		// Body Background Attachment
    		if ( isset( $bg_att ) && !empty( $bg_att ) ) {
    			switch ( $bg_att ) {
    				case 1 : $bg_att = 'fixed'; break;
    				case 2 : $bg_att = 'local'; break;
    			}
    			$html .= 'body { background-attachment: '.$bg_att.' }';
    		}
    		
    	}
    	
    	// Header Color
    	if ( isset( $header_text ) && !empty( $header_text ) ) {
    		$html .= '#header, #header h1, #header small, #header .logo a, #header .page-heading a { color: '.$header_text.' }';
    	}
    	
    	// Header Background Color
    	if ( $header_bg->color() ) {
    		if ( is_numeric( $header_opac ) ) {
    			$html .= '#header-holder { background-color: '.$header_bg->opacity( $header_opac / 100 ).'}';
    		} else {
    			$html .= '#header-holder { background-color: '.$header_bg->opacity( get_option(THEMEPREFIX.'_header_shading_opacity', 55) / 100).'}';
    		}
    	} elseif( is_numeric( $header_opac ) ) {
    		$header_bg = new CurlyThemesColor( get_option(THEMEPREFIX.'_header_shading_color', '#000000') );
    		$html .= '#header-holder { background-color: '.$header_bg->opacity( $header_opac / 100).'}';
    	}
    	
    	
    	
    	// Header Background Image
    	if ( isset( $header_img ) && !empty( $header_img ) ) {
    		$html .= '#header { background-image: url("'.$header_img.'") }';
    		
    		// Header Large Header
    		if ( isset( $header_lg ) && !empty( $header_lg ) ) {
    			if ( !empty( $header_img ) && empty( $header_img_id ) ) {
    				list($width, $height, $type, $attr) = getimagesize(WP_CONTENT_DIR.preg_replace('/(http:\/\/.+)wp-content/','', $header_img));
    			} else {
    				$header_height = wp_get_attachment_image_src( $header_img_id , 'full');
    				$height = $header_height[2];
    			}
    			$html .= '#page-heading, .page-heading{ display:none }';
    			$html .= '#header { min-height:'.$height.'px }';
    		}
    	}
    	
    	// Header Margin Top
    	if ( isset( $header_top ) && $header_top != get_option(THEMEPREFIX.'_header_margin_top') ) {
    		$html .= '#header .logo { margin-top: '.$header_top.'px }';
    	}
    	
    	// Header Margin Bottom
    	if ( isset( $header_bot ) && $header_bot != get_option(THEMEPREFIX.'_header_margin_bottom') ) {
    		$html .= '#header .logo { margin-bottom: '.$header_bot.'px }';
    	}
    	
    	// Push Slider
    	if ( isset( $slider_push ) && !empty( $slider_push ) && $slider != 'no-slider' ) {
    		$html .= '@media (max-width: 767px) { header#header{ position: static !important; background-color: '.get_option( THEMEPREFIX.'_header_shading_color', '#000000' ).'} }';
    	}
    	
    	// Heading Color
    	if ( isset( $heading_color ) && !empty( $heading_color ) ) {
    		$html .= '.page-heading, .page-heading h1, .page-heading a { color: '.$heading_color.' !important}';
    	}
    	
    	// Return $html
    	return $html;
    	
    	} else {
    		return null;
    	}
    }

?>